/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.listener.BlockingEvent;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.ExceptionUtils;
import org.limewire.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerList<E>
implements ListenerSupport<E>,
EventBroadcaster<E> {
    private final Log log;
    private final List<ListenerProxy<E>> listenerList = new CopyOnWriteArrayList<ListenerProxy<E>>();

    public EventListenerList() {
        this.log = null;
    }

    public EventListenerList(Class clazz) {
        this.log = LogFactory.getLog(clazz);
    }

    public EventListenerList(Log log) {
        this.log = log;
    }

    public static <E> void dispatch(EventListener<E> eventListener, E e) {
        ListenerProxy<E> listenerProxy = new ListenerProxy<E>(null, Objects.nonNull(eventListener, "listener"));
        listenerProxy.handleEvent(e);
    }

    @Override
    public void addListener(EventListener<E> eventListener) {
        if (this.log != null) {
            this.log.debugf("adding listener {0} to {1}", (Object)eventListener, (Object)this);
        }
        this.listenerList.add(new ListenerProxy<E>(this.log, Objects.nonNull(eventListener, "listener")));
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        if (this.log != null) {
            this.log.debugf("removing listener {0} from {1}", (Object)eventListener, (Object)this);
        }
        Objects.nonNull(eventListener, "listener");
        for (ListenerProxy<E> listenerProxy : this.listenerList) {
            if (!((ListenerProxy)listenerProxy).delegate.equals(eventListener)) continue;
            return this.listenerList.remove(listenerProxy);
        }
        return false;
    }

    @Override
    public void broadcast(E e) {
        Objects.nonNull(e, "event");
        if (this.log != null) {
            this.log.debugf("broadcasting event {0} from {1}", (Object)e, (Object)this);
        }
        Throwable throwable = null;
        for (ListenerProxy<E> listenerProxy : this.listenerList) {
            try {
                listenerProxy.handleEvent(e);
            }
            catch (Throwable throwable2) {
                Throwable throwable3;
                if (this.log != null) {
                    this.log.error("error dispatching " + e, throwable2);
                }
                if ((throwable3 = ExceptionUtils.reportOrReturn(throwable2)) == null || throwable != null) continue;
                throwable = throwable3;
            }
        }
        if (throwable != null) {
            ExceptionUtils.reportOrRethrow(throwable);
        }
    }

    public int size() {
        return this.listenerList.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListenerProxy<E>
    implements EventListener<E> {
        private final Log log;
        private final EventListener<E> delegate;
        private volatile DispatchType type = DispatchType.UNKNOWN;

        public ListenerProxy(Log log, EventListener<E> eventListener) {
            this.log = log;
            this.delegate = eventListener;
        }

        @Override
        public void handleEvent(E e) {
            if (this.type == DispatchType.UNKNOWN) {
                this.type = this.analyze(this.delegate, e);
            }
            if (this.log != null) {
                this.log.tracef("Dispatching event {0} to {1} of type {2}", (Object)e, (Object)this.delegate, (Object)this.type);
            }
            this.type.dispatch(this.delegate, e);
        }

        private DispatchType analyze(EventListener<E> eventListener, E e) {
            Method method = null;
            for (Class<?> clazz = e.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    method = eventListener.getClass().getMethod("handleEvent", clazz);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (method == null) {
                throw new IllegalStateException("Unable to find method!");
            }
            if (method.getAnnotation(SwingEDTEvent.class) != null) {
                return DispatchType.SWING;
            }
            if (method.getAnnotation(BlockingEvent.class) != null) {
                return DispatchType.BLOCKING;
            }
            return DispatchType.INLINE;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum DispatchType {
            UNKNOWN{

                @Override
                <E> void dispatch(EventListener<E> eventListener, E e) {
                    throw new IllegalStateException("unknown dispatch!");
                }
            }
            ,
            INLINE{

                @Override
                <E> void dispatch(EventListener<E> eventListener, E e) {
                    eventListener.handleEvent(e);
                }
            }
            ,
            SWING{

                @Override
                <E> void dispatch(final EventListener<E> eventListener, final E e) {
                    if (EventQueue.isDispatchThread()) {
                        eventListener.handleEvent(e);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                eventListener.handleEvent(e);
                            }
                        });
                    }
                }
            }
            ,
            BLOCKING{

                @Override
                <E> void dispatch(final EventListener<E> eventListener, final E e) {
                    ThreadExecutor.startThread(new Runnable(){

                        public void run() {
                            eventListener.handleEvent(e);
                        }
                    }, "BlockingEvent");
                }
            };


            abstract <E> void dispatch(EventListener<E> var1, E var2);
        }
    }
}

