/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.PendingEventBroadcaster;
import org.limewire.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingEventMulticasterImpl<E>
implements EventMulticaster<E>,
PendingEventBroadcaster<E> {
    private final EventMulticaster<E> multicaster;
    private final ConcurrentLinkedQueue<E> queuedEvents = new ConcurrentLinkedQueue();
    private final AtomicBoolean firing = new AtomicBoolean();

    public PendingEventMulticasterImpl() {
        this(new EventMulticasterImpl());
    }

    public PendingEventMulticasterImpl(EventMulticaster<E> eventMulticaster) {
        this.multicaster = eventMulticaster;
    }

    @Override
    public void addListener(EventListener<E> eventListener) {
        this.multicaster.addListener(eventListener);
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        return this.multicaster.removeListener(eventListener);
    }

    @Override
    public void handleEvent(E e) {
        this.broadcast(e);
    }

    @Override
    public void broadcast(E e) {
        this.addPendingEvent(e);
        this.firePendingEvents();
    }

    @Override
    public void addPendingEvent(E e) {
        this.queuedEvents.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePendingEvents() {
        while (!this.queuedEvents.isEmpty() && this.firing.compareAndSet(false, true)) {
            try {
                E e;
                Throwable throwable = null;
                while ((e = this.queuedEvents.poll()) != null) {
                    try {
                        this.multicaster.broadcast(e);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = ExceptionUtils.reportOrReturn(throwable2);
                        if (throwable3 == null || throwable != null) continue;
                        throwable = throwable3;
                    }
                }
                if (throwable == null) continue;
                ExceptionUtils.reportOrRethrow(throwable);
            }
            finally {
                this.firing.set(false);
            }
        }
    }
}

