/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.service;

import org.limewire.service.MessageCallback;
import org.limewire.service.Switch;

public class MessageService {
    private static volatile MessageCallback _callback = new ShellMessageService();

    private MessageService() {
    }

    public static void setCallback(MessageCallback messageCallback) {
        _callback = messageCallback;
    }

    public static MessageCallback getCallback() {
        return _callback;
    }

    public static void showError(String string) {
        _callback.showError(string);
    }

    public static void showError(String string, Switch switch_) {
        _callback.showError(string, switch_);
    }

    public static void showMessage(String string) {
        _callback.showMessage(string);
    }

    public static void showMessage(String string, Switch switch_) {
        _callback.showMessage(string, switch_);
    }

    public static void showFormattedMessage(String string, Object ... objectArray) {
        _callback.showFormattedMessage(string, objectArray);
    }

    public static void showFormattedMessage(String string, Switch switch_, Object ... objectArray) {
        _callback.showFormattedMessage(string, switch_, objectArray);
    }

    public static void showFormattedError(String string, Object ... objectArray) {
        _callback.showFormattedError(string, objectArray);
    }

    public static void showFormattedError(String string, Switch switch_, Object ... objectArray) {
        _callback.showFormattedError(string, switch_, objectArray);
    }

    private static final class ShellMessageService
    implements MessageCallback {
        private ShellMessageService() {
        }

        public void showError(String string) {
            System.out.println("error key: " + string);
        }

        public void showError(String string, Switch switch_) {
            this.showError(string);
        }

        public void showError(String string, String string2) {
            System.out.println("error key: " + string + " extra message: " + string2);
        }

        public void showError(String string, String string2, Switch switch_) {
            this.showError(string, string2);
        }

        public void showMessage(String string) {
            System.out.println("message key: " + string);
        }

        public void showMessage(String string, Switch switch_) {
            this.showMessage(string);
        }

        public void showFormattedMessage(String string, Object ... objectArray) {
            StringBuilder stringBuilder = new StringBuilder("message key: " + string + " ");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append("arg[" + i + "]: " + objectArray[i]);
                if (i >= objectArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            System.out.println(stringBuilder);
        }

        public void showFormattedMessage(String string, Switch switch_, Object ... objectArray) {
            this.showFormattedMessage(string, objectArray);
        }

        public void showFormattedError(String string, Object ... objectArray) {
            StringBuilder stringBuilder = new StringBuilder("error key: " + string + " ");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append("arg[" + i + "]: " + objectArray[i]);
                if (i >= objectArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            System.out.println(stringBuilder);
        }

        public void showFormattedError(String string, Switch switch_, Object ... objectArray) {
            this.showFormattedError(string, objectArray);
        }
    }
}

