/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class RPNParser {
    private static final Map<String, Predicate> predicateByOperand;
    private static final Set<String> experimentalPredicates;
    private final String[] expression;
    private final boolean experimental;
    private final Stack<String> stack = new Stack();

    public RPNParser(String ... stringArray) {
        this(true, stringArray);
    }

    public RPNParser(boolean bl, String ... stringArray) {
        this.expression = stringArray;
        this.experimental = bl;
    }

    public boolean evaluate() {
        return this.evaluate(new StringLookup(){

            public String lookup(String string) {
                return string;
            }
        });
    }

    public boolean evaluate(StringLookup stringLookup) {
        for (String string : this.expression) {
            if (string == null) {
                throw new IllegalArgumentException("null input");
            }
            if (!predicateByOperand.containsKey(string)) {
                String string2 = stringLookup.lookup(string);
                this.stack.push(string2 != null ? string2 : string);
                continue;
            }
            if (!this.experimental && experimentalPredicates.contains(string)) continue;
            this.evaluateOp(string);
        }
        if (this.stack.size() != 1) {
            throw new IllegalArgumentException(this.stack.size() + " elements at end of parse");
        }
        return Boolean.valueOf(this.stack.pop());
    }

    private void evaluateOp(String string) {
        Predicate predicate = predicateByOperand.get(string);
        if (this.stack.size() < predicate.numOperands()) {
            throw new IllegalArgumentException("not enough operands" + predicate.numOperands());
        }
        String[] stringArray = new String[predicate.numOperands()];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringArray[i] = this.stack.pop();
        }
        this.stack.push(new Boolean(predicate.evaluate(stringArray)).toString());
    }

    static boolean strictBoolean(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    static {
        HashMap<String, Predicate> hashMap = new HashMap<String, Predicate>();
        HashSet<String> hashSet = new HashSet<String>();
        hashMap.put("==", new EqualsPredicate());
        hashMap.put("<", new LessPredicate());
        hashMap.put(">", new GreaterPredicate());
        hashMap.put("NOT", new NOTPredicate());
        hashMap.put("OR", new ORPredicate());
        hashMap.put("AND", new ANDPredicate());
        hashMap.put("CONTAINS", new ContainsPredicate());
        hashMap.put("MATCHES", new MatchesPredicate());
        hashSet.add("MATCHES");
        predicateByOperand = Collections.unmodifiableMap(hashMap);
        experimentalPredicates = Collections.unmodifiableSet(hashSet);
    }

    static class MatchesPredicate
    extends Predicate {
        MatchesPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException();
            }
            return Pattern.matches(stringArray[0], stringArray[1]);
        }
    }

    static class ContainsPredicate
    extends Predicate {
        ContainsPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException();
            }
            return stringArray[0].toLowerCase().contains(stringArray[1].toLowerCase());
        }
    }

    static class LessPredicate
    extends Predicate {
        LessPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException();
            }
            return Double.valueOf(stringArray[0]) < Double.valueOf(stringArray[1]);
        }
    }

    static class GreaterPredicate
    extends Predicate {
        GreaterPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException();
            }
            return Double.valueOf(stringArray[0]) > Double.valueOf(stringArray[1]);
        }
    }

    static class NOTPredicate
    extends Predicate {
        NOTPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 1) {
                throw new IllegalArgumentException();
            }
            return !RPNParser.strictBoolean(stringArray[0]);
        }

        public int numOperands() {
            return 1;
        }
    }

    static class ANDPredicate
    extends Predicate {
        ANDPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException();
            }
            return RPNParser.strictBoolean(stringArray[0]) && RPNParser.strictBoolean(stringArray[1]);
        }
    }

    static class ORPredicate
    extends Predicate {
        ORPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException();
            }
            return RPNParser.strictBoolean(stringArray[0]) || RPNParser.strictBoolean(stringArray[1]);
        }
    }

    static class EqualsPredicate
    extends Predicate {
        EqualsPredicate() {
        }

        public boolean evaluate(String ... stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException();
            }
            return stringArray[0].equals(stringArray[1]);
        }
    }

    private static abstract class Predicate {
        private Predicate() {
        }

        public abstract boolean evaluate(String ... var1);

        public int numOperands() {
            return 2;
        }
    }

    public static interface StringLookup {
        public String lookup(String var1);
    }
}

