/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static volatile Collator COLLATOR = Collator.getInstance(Locale.getDefault());

    public static void setLocale(Locale locale) {
        Collator collator = Collator.getInstance(locale);
        collator.setDecomposition(2);
        collator.setStrength(0);
        COLLATOR = collator;
    }

    public static final boolean contains(String string, String string2) {
        return StringUtils.contains(string, string2, false);
    }

    public static final boolean contains(String string, String string2, boolean bl) {
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6 = 32;
            for (n5 = n3; n5 < n; ++n5) {
                n4 = string2.charAt(n5);
                if (n4 != 32 && n4 != 43 && n4 != 42) continue;
                n6 = n4;
                break;
            }
            if ((n4 = StringUtils.subset(string2, n3, n5, string, n2, bl)) < 0) {
                return false;
            }
            if (n6 == 32 || n6 == 43) {
                n2 = 0;
            } else if (n6 == 42) {
                n2 = n4 + n5 - n3;
            }
            n3 = n5 + 1;
        }
        return true;
    }

    public static boolean containsCharacters(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        Arrays.sort(cArray2);
        for (int i = 0; i < cArray.length; ++i) {
            if (Arrays.binarySearch(cArray2, cArray[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private static final int subset(String string, int n, int n2, String string2, int n3, boolean bl) {
        if (bl) {
            int n4 = string2.length() - (n2 - n) + 1;
            block0: for (int i = n3; i < n4; ++i) {
                int n5 = n2 - n;
                for (int j = 0; j < n5; ++j) {
                    char c;
                    char c2 = string2.charAt(i + j);
                    if (c2 != (c = string.charAt(n + j)) && c2 != StringUtils.toOtherCase(c)) continue block0;
                }
                return i;
            }
            return -1;
        }
        int n6 = string2.length() - (n2 - n) + 1;
        block2: for (int i = n3; i < n6; ++i) {
            int n7 = n2 - n;
            for (int j = 0; j < n7; ++j) {
                char c;
                char c3 = string2.charAt(i + j);
                if (c3 != (c = string.charAt(n + j))) continue block2;
            }
            return i;
        }
        return -1;
    }

    public static final char toOtherCase(char c) {
        char c2 = c;
        if (c2 < 'A') {
            return c;
        }
        if (c2 <= 'Z') {
            return (char)(c2 + 32);
        }
        if (c2 < 'a') {
            return c;
        }
        if (c2 <= 'z') {
            return (char)(c2 - 32);
        }
        return c;
    }

    public static String[] split(String string, char c) {
        return StringUtils.split(string, Character.toString(c));
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] splitNoCoalesce(String string, char c) {
        return StringUtils.splitNoCoalesce(string, Character.toString(c));
    }

    public static String[] splitNoCoalesce(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1 && string2.indexOf(string3) >= 0) {
                if (bl) {
                    arrayList.add("");
                }
                bl = true;
                continue;
            }
            arrayList.add(string3);
            bl = false;
        }
        if (bl && !arrayList.isEmpty()) {
            arrayList.add("");
        }
        return arrayList.toArray(new String[0]);
    }

    public static int compareFullPrimary(String string, String string2) {
        return COLLATOR.compare(string, string2);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        if (string.length() < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.indexOf(string2);
        while (n2 > -1) {
            if (n2 > n) {
                stringBuilder.append(string.substring(n, n2));
            }
            stringBuilder.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n2 + 1);
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    public static String truncate(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtils.indexOfIgnoreCase(string, string2, Locale.getDefault());
    }

    public static int indexOfIgnoreCase(String string, String string2, Locale locale) {
        return string.toLowerCase(locale).indexOf(string2.toLowerCase(locale));
    }

    public static String getASCIIString(byte[] byArray) {
        return StringUtils.getEncodedString(byArray, "ISO-8859-1");
    }

    public static String getUTF8String(byte[] byArray) {
        return StringUtils.getEncodedString(byArray, "UTF-8");
    }

    public static String getASCIIString(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, Charset.forName("ISO-8859-1"));
    }

    private static String getEncodedString(byte[] byArray, String string) {
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String explode(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public static String explode(Collection<String> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!collection.isEmpty()) {
            Iterator<String> iterator = collection.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(string);
                stringBuilder.append(iterator.next());
            }
        }
        return stringBuilder.toString();
    }

    static {
        COLLATOR.setDecomposition(2);
        COLLATOR.setStrength(0);
    }
}

