/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.limewire.collection.PatriciaTrie;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.security.SecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KUID
implements Comparable<KUID>,
Serializable {
    private static final long serialVersionUID = 633717248208386374L;
    private static final Random GENERATOR = SecurityUtils.createSecureRandomNoBlock();
    public static final int LENGTH = 20;
    public static final int LENGTH_IN_BITS = 160;
    private static final int[] BITS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final KUID MINIMUM;
    public static final KUID MAXIMUM;
    private final byte[] id;
    private final int hashCode;
    public static final PatriciaTrie.KeyAnalyzer<KUID> KEY_ANALYZER;

    protected KUID(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("ID is null");
        }
        if (byArray.length != 20) {
            throw new IllegalArgumentException("ID must be 20 bytes long");
        }
        this.id = byArray;
        this.hashCode = Arrays.hashCode(byArray);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.id, 0, this.id.length);
    }

    public boolean isBitSet(int n) {
        int n2 = n / BITS.length;
        int n3 = n - n2 * BITS.length;
        return (this.id[n2] & BITS[n3]) != 0;
    }

    public KUID set(int n) {
        return this.set(n, true);
    }

    public KUID unset(int n) {
        return this.set(n, false);
    }

    public KUID flip(int n) {
        return this.set(n, !this.isBitSet(n));
    }

    private KUID set(int n, boolean bl) {
        boolean bl2;
        int n2 = n / BITS.length;
        int n3 = n - n2 * BITS.length;
        boolean bl3 = bl2 = (this.id[n2] & BITS[n3]) != 0;
        if (bl2 != bl) {
            byte[] byArray = this.getBytes();
            int n4 = n2;
            byArray[n4] = (byte)(byArray[n4] ^ BITS[n3]);
            return new KUID(byArray);
        }
        return this;
    }

    public int bits() {
        int n = 0;
        for (int i = 0; i < 160; ++i) {
            if (!this.isBitSet(i)) continue;
            ++n;
        }
        return n;
    }

    public int bitIndex(KUID kUID) {
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < this.id.length; ++i) {
            if (bl && this.id[i] != 0) {
                bl = false;
            }
            if (this.id[i] != kUID.id[i]) {
                for (int j = 0; j < BITS.length && (this.id[i] & BITS[j]) == (kUID.id[i] & BITS[j]); ++j) {
                    ++n;
                }
                break;
            }
            n += BITS.length;
        }
        if (bl) {
            return -1;
        }
        if (n == 160) {
            return -2;
        }
        return n;
    }

    public KUID xor(KUID kUID) {
        byte[] byArray = new byte[this.id.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(this.id[i] ^ kUID.id[i]);
        }
        return new KUID(byArray);
    }

    public KUID invert() {
        byte[] byArray = new byte[this.id.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = ~this.id[i];
        }
        return new KUID(byArray);
    }

    public boolean isNearerTo(KUID kUID, KUID kUID2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.id.length; ++i) {
            n = (this.id[i] ^ kUID.id[i]) & 0xFF;
            n2 = (kUID2.id[i] ^ kUID.id[i]) & 0xFF;
            if (n < n2) {
                return true;
            }
            if (n <= n2) continue;
            return false;
        }
        return false;
    }

    public byte[] getBytes() {
        return this.getBytes(0, new byte[this.id.length], 0, this.id.length);
    }

    public byte[] getBytes(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.id, n, byArray, n2, n3);
        return byArray;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(KUID kUID) {
        int n = 0;
        for (int i = 0; i < this.id.length; ++i) {
            n = (this.id[i] & 0xFF) - (kUID.id[i] & 0xFF);
            if (n < 0) {
                return -1;
            }
            if (n <= 0) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KUID)) {
            return false;
        }
        return Arrays.equals(this.id, ((KUID)object).id);
    }

    public String toHexString() {
        return ArrayUtils.toHexString(this.id);
    }

    public String toBinString() {
        return ArrayUtils.toBinString(this.id);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.id);
    }

    public int log2() {
        return this.toBigInteger().bitLength();
    }

    public String toString() {
        return this.toHexString();
    }

    public static KUID createRandomID() {
        MessageDigestInput messageDigestInput = new MessageDigestInput(){

            public void update(MessageDigest messageDigest) {
                byte[] byArray = new byte[40];
                GENERATOR.nextBytes(byArray);
                messageDigest.update(byArray);
            }
        };
        MessageDigestInput messageDigestInput2 = new MessageDigestInput(){

            public void update(MessageDigest messageDigest) {
                Properties properties = System.getProperties();
                try {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String string = (String)entry.getKey();
                        String string2 = (String)entry.getValue();
                        messageDigest.update(string.getBytes("UTF-8"));
                        messageDigest.update(string2.getBytes("UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
            }
        };
        MessageDigestInput messageDigestInput3 = new MessageDigestInput(){

            public void update(MessageDigest messageDigest) {
                long l = System.currentTimeMillis();
                messageDigest.update((byte)(l >> 56 & 0xFFL));
                messageDigest.update((byte)(l >> 48 & 0xFFL));
                messageDigest.update((byte)(l >> 40 & 0xFFL));
                messageDigest.update((byte)(l >> 32 & 0xFFL));
                messageDigest.update((byte)(l >> 24 & 0xFFL));
                messageDigest.update((byte)(l >> 16 & 0xFFL));
                messageDigest.update((byte)(l >> 8 & 0xFFL));
                messageDigest.update((byte)(l & 0xFFL));
            }
        };
        MessageDigestInput messageDigestInput4 = new MessageDigestInput(){

            public void update(MessageDigest messageDigest) {
                long l = System.nanoTime();
                messageDigest.update((byte)(l >> 56 & 0xFFL));
                messageDigest.update((byte)(l >> 48 & 0xFFL));
                messageDigest.update((byte)(l >> 40 & 0xFFL));
                messageDigest.update((byte)(l >> 32 & 0xFFL));
                messageDigest.update((byte)(l >> 24 & 0xFFL));
                messageDigest.update((byte)(l >> 16 & 0xFFL));
                messageDigest.update((byte)(l >> 8 & 0xFFL));
                messageDigest.update((byte)(l & 0xFFL));
            }
        };
        Object[] objectArray = new MessageDigestInput[]{messageDigestInput2, messageDigestInput, messageDigestInput3, messageDigestInput4};
        Arrays.sort(objectArray);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            for (Object object : objectArray) {
                ((MessageDigestInput)object).update(messageDigest);
                int n = System.identityHashCode(object);
                messageDigest.update((byte)(n >> 24 & 0xFF));
                messageDigest.update((byte)(n >> 16 & 0xFF));
                messageDigest.update((byte)(n >> 8 & 0xFF));
                messageDigest.update((byte)(n & 0xFF));
                messageDigest.update((byte)(((MessageDigestInput)object).rnd >> 24 & 0xFF));
                messageDigest.update((byte)(((MessageDigestInput)object).rnd >> 16 & 0xFF));
                messageDigest.update((byte)(((MessageDigestInput)object).rnd >> 8 & 0xFF));
                messageDigest.update((byte)(((MessageDigestInput)object).rnd & 0xFF));
            }
            return new KUID(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static KUID createWithBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return new KUID(byArray2);
    }

    public static KUID createWithHexString(String string) {
        return new KUID(ArrayUtils.parseHexString(string));
    }

    public static KUID createWithInputStream(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[20];
        int n = -1;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
        return new KUID(byArray);
    }

    public static KUID createPrefxNodeID(KUID kUID, int n) {
        byte[] byArray = new byte[20];
        GENERATOR.nextBytes(byArray);
        return KUID.createPrefxNodeID(kUID, n, byArray);
    }

    private static KUID createPrefxNodeID(KUID kUID, int n, byte[] byArray) {
        int n2 = ++n / 8;
        System.arraycopy(kUID.id, 0, byArray, 0, n2);
        int n3 = n % 8;
        if (n3 != 0) {
            int n4 = (1 << 8 - n3) - 1;
            byte by = kUID.id[n2];
            byte by2 = byArray[n2];
            byArray[n2] = (byte)(by & ~n4 | by2 & n4);
        }
        return new KUID(byArray);
    }

    static {
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        Arrays.fill(byArray2, (byte)-1);
        MINIMUM = new KUID(byArray);
        MAXIMUM = new KUID(byArray2);
        KEY_ANALYZER = new KUIDKeyAnalyzer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KUIDKeyAnalyzer
    implements PatriciaTrie.KeyAnalyzer<KUID> {
        private static final long serialVersionUID = 6412279289438108492L;

        private KUIDKeyAnalyzer() {
        }

        public int bitIndex(KUID kUID, int n, int n2, KUID kUID2, int n3, int n4) {
            if (kUID2 == null) {
                kUID2 = MINIMUM;
            }
            return kUID.bitIndex(kUID2);
        }

        public int bitsPerElement() {
            return 1;
        }

        public boolean isBitSet(KUID kUID, int n, int n2) {
            return kUID.isBitSet(n2);
        }

        public boolean isPrefix(KUID kUID, int n, int n2, KUID kUID2) {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                if (kUID.isBitSet(i) == kUID2.isBitSet(i)) continue;
                return false;
            }
            return true;
        }

        public int length(KUID kUID) {
            return 20;
        }

        public int compare(KUID kUID, KUID kUID2) {
            return kUID.compareTo(kUID2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MessageDigestInput
    implements Comparable<MessageDigestInput> {
        private int rnd = KUID.access$100().nextInt();

        private MessageDigestInput() {
        }

        public abstract void update(MessageDigest var1);

        @Override
        public int compareTo(MessageDigestInput messageDigestInput) {
            return this.rnd - messageDigestInput.rnd;
        }
    }
}

