/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.Cancellable;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.exceptions.LockTimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTFutureTask<T>
implements Runnable,
DHTFuture<T>,
Cancellable {
    private static final Log LOG = LogFactory.getLog(DHTFutureTask.class);
    private final OnewayExchanger<T, ExecutionException> exchanger;
    private final Set<DHTFutureListener<T>> listeners = Collections.synchronizedSet(new LinkedHashSet());
    private final Context context;
    private final DHTTask<T> task;
    private boolean taskIsActive;
    private ScheduledFuture<?> watchdog = null;

    public DHTFutureTask(Context context, DHTTask<T> dHTTask) {
        this.task = dHTTask;
        this.context = context;
        this.exchanger = new OnewayExchanger<T, ExecutionException>(true){

            public synchronized void setValue(T t) {
                if (!this.isDone()) {
                    super.setValue(t);
                    DHTFutureTask.this.killWatchdog();
                    DHTFutureTask.this.internalDone();
                }
            }

            public synchronized void setException(ExecutionException executionException) {
                if (!this.isDone()) {
                    super.setException((Throwable)executionException);
                    DHTFutureTask.this.killWatchdog();
                    DHTFutureTask.this.internalDone();
                }
            }

            public synchronized boolean cancel() {
                if (super.cancel()) {
                    DHTFutureTask.this.killWatchdog();
                    DHTFutureTask.this.internalDone();
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            OnewayExchanger<T, ExecutionException> onewayExchanger = this.exchanger;
            synchronized (onewayExchanger) {
                if (this.isDone()) {
                    return;
                }
                this.taskIsActive = true;
            }
            this.task.start(this.exchanger);
            onewayExchanger = this.exchanger;
            synchronized (onewayExchanger) {
                if (!this.isDone()) {
                    this.initWatchdog();
                }
            }
        }
        catch (Throwable throwable) {
            this.exchanger.setException((Throwable)new ExecutionException(throwable));
        }
    }

    private void initWatchdog() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl = false;
                OnewayExchanger onewayExchanger = DHTFutureTask.this.exchanger;
                synchronized (onewayExchanger) {
                    if (!DHTFutureTask.this.isDone()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Watchdog is canceling " + DHTFutureTask.this.task));
                        }
                        bl = DHTFutureTask.this.taskIsActive;
                        DHTFutureTask.this.exchanger.setException((Throwable)new ExecutionException(new LockTimeoutException(DHTFutureTask.this.task.toString())));
                    }
                }
                if (bl) {
                    DHTFutureTask.this.task.cancel();
                }
            }
        };
        this.watchdog = this.context.getDHTExecutorService().schedule(runnable, this.task.getWaitOnLockTimeout(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killWatchdog() {
        OnewayExchanger<T, ExecutionException> onewayExchanger = this.exchanger;
        synchronized (onewayExchanger) {
            if (this.watchdog != null) {
                this.watchdog.cancel(true);
                this.watchdog = null;
            }
        }
    }

    protected void done() {
    }

    private void internalDone() {
        Runnable runnable = new Runnable(){

            public void run() {
                DHTFutureTask.this.done();
                try {
                    Object t = DHTFutureTask.this.get();
                    DHTFutureTask.this.fireFutureResult(t);
                }
                catch (ExecutionException executionException) {
                    DHTFutureTask.this.fireExecutionException(executionException);
                }
                catch (CancellationException cancellationException) {
                    DHTFutureTask.this.fireCancellationException(cancellationException);
                }
                catch (InterruptedException interruptedException) {
                    DHTFutureTask.this.fireInterruptedException(interruptedException);
                }
            }
        };
        this.context.getDHTExecutorService().execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDHTFutureListener(final DHTFutureListener<T> dHTFutureListener) {
        if (dHTFutureListener == null) {
            throw new NullPointerException("DHTFutureListener is null");
        }
        boolean bl = false;
        Object object = this.exchanger;
        synchronized (object) {
            bl = this.isDone();
            if (!bl) {
                this.listeners.add(dHTFutureListener);
            }
        }
        if (bl) {
            object = new Runnable(){

                public void run() {
                    try {
                        Object t = DHTFutureTask.this.get();
                        dHTFutureListener.handleFutureSuccess(t);
                    }
                    catch (ExecutionException executionException) {
                        dHTFutureListener.handleExecutionException(executionException);
                    }
                    catch (CancellationException cancellationException) {
                        dHTFutureListener.handleCancellationException(cancellationException);
                    }
                    catch (InterruptedException interruptedException) {
                        dHTFutureListener.handleInterruptedException(interruptedException);
                    }
                }
            };
            this.context.getDHTExecutorService().execute((Runnable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = false;
        OnewayExchanger<T, ExecutionException> onewayExchanger = this.exchanger;
        synchronized (onewayExchanger) {
            if (!(this.isDone() || this.taskIsActive && !bl)) {
                this.exchanger.cancel();
                bl2 = this.taskIsActive;
            }
        }
        if (bl2) {
            this.task.cancel();
        }
        return bl2;
    }

    @Override
    public final boolean isCancelled() {
        return this.exchanger.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.exchanger.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.exchanger.get();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.exchanger.get(l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFutureListener<T>[] listeners() {
        Set<DHTFutureListener<T>> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new DHTFutureListener[0]);
        }
    }

    protected void fireFutureResult(T t) {
        for (DHTFutureListener<T> dHTFutureListener : this.listeners()) {
            dHTFutureListener.handleFutureSuccess(t);
        }
    }

    protected void fireExecutionException(ExecutionException executionException) {
        for (DHTFutureListener<T> dHTFutureListener : this.listeners()) {
            dHTFutureListener.handleExecutionException(executionException);
        }
    }

    protected void fireCancellationException(CancellationException cancellationException) {
        for (DHTFutureListener<T> dHTFutureListener : this.listeners()) {
            dHTFutureListener.handleCancellationException(cancellationException);
        }
    }

    protected void fireInterruptedException(InterruptedException interruptedException) {
        for (DHTFutureListener<T> dHTFutureListener : this.listeners) {
            dHTFutureListener.handleInterruptedException(interruptedException);
        }
    }
}

