/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedDHTFuture<T>
implements DHTFuture<T> {
    private final OnewayExchanger<T, ExecutionException> exchanger = new OnewayExchanger(true);

    public FixedDHTFuture(T t) {
        this.exchanger.setValue(t);
    }

    public FixedDHTFuture(Exception exception) {
        this.exchanger.setException((Throwable)new ExecutionException(exception));
    }

    @Override
    public void addDHTFutureListener(DHTFutureListener<T> dHTFutureListener) {
        if (dHTFutureListener == null) {
            throw new NullPointerException("DHTFutureListener is null");
        }
        try {
            T t = this.get();
            dHTFutureListener.handleFutureSuccess(t);
        }
        catch (ExecutionException executionException) {
            dHTFutureListener.handleExecutionException(executionException);
        }
        catch (CancellationException cancellationException) {
            dHTFutureListener.handleCancellationException(cancellationException);
        }
        catch (InterruptedException interruptedException) {
            dHTFutureListener.handleInterruptedException(interruptedException);
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.exchanger.cancel();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.exchanger.get();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.exchanger.get(l, timeUnit);
    }

    @Override
    public boolean isCancelled() {
        return this.exchanger.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.exchanger.isDone();
    }
}

