/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.io.Serializable;
import java.util.Map;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.mojito.util.FixedSizeHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DHTValueType
implements Comparable<DHTValueType>,
Serializable {
    private static final long serialVersionUID = -3662336008253896020L;
    private static final String UNKNOWN_NAME = "UNKNOWN";
    private static final Map<Integer, DHTValueType> TYPES = new FixedSizeHashMap<Integer, DHTValueType>(16, 0.75f, true, 254);
    public static final DHTValueType BINARY = DHTValueType.valueOf("Binary", 0);
    public static final DHTValueType LIME = DHTValueType.valueOf("LimeWire", "LIME");
    public static final DHTValueType TEXT = DHTValueType.valueOf("UTF-8 Encoded String", "TEXT");
    public static final DHTValueType TEST = DHTValueType.valueOf("Test Value", "TEST");
    public static final DHTValueType ANY = DHTValueType.valueOf("Any Type", "****");
    private final String name;
    private final int type;

    private DHTValueType(String string, int n) {
        this.name = string;
        this.type = n;
    }

    public String getName() {
        return this.name;
    }

    public int toInt() {
        return this.type;
    }

    @Override
    public int compareTo(DHTValueType dHTValueType) {
        return this.type - dHTValueType.type;
    }

    public int hashCode() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DHTValueType)) {
            return false;
        }
        return this.compareTo((DHTValueType)object) == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name.equals(UNKNOWN_NAME)) {
            stringBuilder.append(ArrayUtils.toString(this.type)).append("/").append(this.name);
        } else {
            stringBuilder.append(this.name);
        }
        stringBuilder.append(" (0x").append(Long.toHexString((long)this.type & 0xFFFFFFFFL)).append(")");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTValueType[] values() {
        Map<Integer, DHTValueType> map = TYPES;
        synchronized (map) {
            return TYPES.values().toArray(new DHTValueType[0]);
        }
    }

    public static DHTValueType valueOf(int n) {
        return DHTValueType.valueOf(UNKNOWN_NAME, n);
    }

    public static DHTValueType valueOf(String string) {
        return DHTValueType.valueOf(UNKNOWN_NAME, string);
    }

    public static DHTValueType valueOf(String string, String string2) {
        return DHTValueType.valueOf(string, ArrayUtils.toInteger(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTValueType valueOf(String string, int n) {
        Integer n2 = n;
        Map<Integer, DHTValueType> map = TYPES;
        synchronized (map) {
            DHTValueType dHTValueType = TYPES.get(n2);
            if (dHTValueType == null || DHTValueType.isBetterName(dHTValueType, string)) {
                dHTValueType = new DHTValueType(string, n);
                TYPES.put(n2, dHTValueType);
            }
            return dHTValueType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Integer n = this.type;
        DHTValueType dHTValueType = null;
        Map<Integer, DHTValueType> map = TYPES;
        synchronized (map) {
            dHTValueType = TYPES.get(n);
            if (dHTValueType == null || DHTValueType.isBetterName(dHTValueType, this.name)) {
                dHTValueType = this;
                TYPES.put(n, dHTValueType);
            }
        }
        return dHTValueType;
    }

    private static boolean isBetterName(DHTValueType dHTValueType, String string) {
        return dHTValueType.name.equals(UNKNOWN_NAME) && !string.equals(UNKNOWN_NAME);
    }
}

