/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.ContactUtils;

public class FindNodeRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(FindNodeRequestHandler.class);

    public FindNodeRequestHandler(Context context) {
        super(context);
    }

    protected void request(RequestMessage requestMessage) throws IOException {
        LookupRequest lookupRequest = (LookupRequest)requestMessage;
        KUID kUID = lookupRequest.getLookupID();
        Contact contact = lookupRequest.getContact();
        Collection<Object> collection = Collections.emptyList();
        if (!this.context.isBootstrapping()) {
            if (this.context.isFirewalled()) {
                collection = ContactUtils.sort(this.context.getRouteTable().getContacts(), KademliaSettings.REPLICATION_PARAMETER.getValue());
                if (this.context.getExternalPort() == 0) {
                    collection.remove(this.context.getLocalNode());
                }
            } else {
                collection = this.context.getRouteTable().select(kUID, KademliaSettings.REPLICATION_PARAMETER.getValue(), RouteTable.SelectMode.ALIVE);
            }
        }
        if (LOG.isTraceEnabled()) {
            if (!collection.isEmpty()) {
                LOG.trace((Object)("Sending back: " + CollectionUtils.toString(collection)));
            } else {
                LOG.trace((Object)"Sending back an empty List");
            }
        }
        this.context.getNetworkStats().LOOKUP_REQUESTS.incrementStat();
        FindNodeResponse findNodeResponse = this.context.getMessageHelper().createFindNodeResponse(lookupRequest, collection);
        this.context.getMessageDispatcher().send(contact, findNodeResponse);
    }
}

