/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.statistics.NetworkStatisticContainer;
import org.limewire.mojito.util.MessageUtils;

public class PingRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(PingRequestHandler.class);
    private final NetworkStatisticContainer networkStats;

    public PingRequestHandler(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    public void request(RequestMessage requestMessage) throws IOException {
        this.networkStats.PING_REQUESTS.incrementStat();
        PingRequest pingRequest = (PingRequest)requestMessage;
        Contact contact = pingRequest.getContact();
        if (this.context.isBootstrapping() && !MessageUtils.isCollisionPingRequest(this.context.getLocalNodeID(), requestMessage)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Received a PingRequest from " + contact + " but local Node is bootstrapping"));
            }
            return;
        }
        PingResponse pingResponse = this.context.getMessageHelper().createPingResponse(pingRequest, contact.getContactAddress());
        this.context.getMessageDispatcher().send(contact, pingResponse);
        this.networkStats.PONGS_SENT.incrementStat();
    }
}

