/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.statistics.NetworkStatisticContainer;

public class StatsRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(StatsRequestHandler.class);
    private final NetworkStatisticContainer networkStats;

    public StatsRequestHandler(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    public void request(RequestMessage requestMessage) throws IOException {
        StatsRequest statsRequest = (StatsRequest)requestMessage;
        if (!statsRequest.isSecure()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(requestMessage.getContact() + " sent us an invalid Stats Request"));
            }
            return;
        }
        this.networkStats.STATS_REQUEST.incrementStat();
        StringWriter stringWriter = new StringWriter();
        switch (statsRequest.getType()) {
            case STATISTICS: {
                this.context.getDHTStats().dump(stringWriter, false);
                break;
            }
            case DATABASE: {
                stringWriter.write(this.context.getDatabase().toString());
                break;
            }
            case ROUTETABLE: {
                stringWriter.write(this.context.getRouteTable().toString());
                break;
            }
            default: {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Unknown stats request: " + (Object)((Object)statsRequest.getType())));
                }
                return;
            }
        }
        StatsResponse statsResponse = this.context.getMessageHelper().createStatsResponse(requestMessage, stringWriter.toString().getBytes("ISO-8859-1"));
        this.context.getMessageDispatcher().send(requestMessage.getContact(), statsResponse);
    }
}

