/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.statistics.NetworkStatisticContainer;
import org.limewire.security.SecurityToken;

public class StoreRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(StoreRequestHandler.class);
    private NetworkStatisticContainer networkStats;

    public StoreRequestHandler(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    public void request(RequestMessage requestMessage) throws IOException {
        StoreRequest storeRequest = (StoreRequest)requestMessage;
        this.networkStats.STORE_REQUESTS.incrementStat();
        SecurityToken securityToken = storeRequest.getSecurityToken();
        if (securityToken == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(storeRequest.getContact() + " does not provide a SecurityToken"));
            }
            this.networkStats.STORE_REQUESTS_NO_QK.incrementStat();
            return;
        }
        Contact contact = storeRequest.getContact();
        SecurityToken.TokenData tokenData = this.context.getSecurityTokenHelper().createTokenData(contact);
        if (!securityToken.isFor(tokenData)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(storeRequest.getContact() + " send us an invalid SecurityToken " + securityToken));
            }
            this.networkStats.STORE_REQUESTS_BAD_QK.incrementStat();
            return;
        }
        Collection<? extends DHTValueEntity> collection = storeRequest.getDHTValueEntities();
        ArrayList<StoreResponse.StoreStatusCode> arrayList = new ArrayList<StoreResponse.StoreStatusCode>(collection.size());
        Database database = this.context.getDatabase();
        for (DHTValueEntity dHTValueEntity : collection) {
            if (database.store(dHTValueEntity)) {
                this.networkStats.STORE_REQUESTS_OK.incrementStat();
                arrayList.add(new StoreResponse.StoreStatusCode(dHTValueEntity, StoreResponse.OK));
                continue;
            }
            this.networkStats.STORE_REQUESTS_FAILURE.incrementStat();
            arrayList.add(new StoreResponse.StoreStatusCode(dHTValueEntity, StoreResponse.ERROR));
        }
        StoreResponse storeResponse = this.context.getMessageHelper().createStoreResponse(storeRequest, arrayList);
        this.context.getMessageDispatcher().send(storeRequest.getContact(), storeResponse);
    }
}

