/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.IllegalSocketAddressException;
import org.limewire.mojito.handler.DefaultMessageHandler;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.handler.request.FindNodeRequestHandler;
import org.limewire.mojito.handler.request.FindValueRequestHandler;
import org.limewire.mojito.handler.request.PingRequestHandler;
import org.limewire.mojito.handler.request.StatsRequestHandler;
import org.limewire.mojito.handler.request.StoreRequestHandler;
import org.limewire.mojito.io.Tag;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.DHTSecureMessage;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.FixedSizeHashMap;
import org.limewire.mojito.util.HostFilter;
import org.limewire.mojito.util.MessageUtils;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;

public abstract class MessageDispatcher {
    private static final Log LOG = LogFactory.getLog(MessageDispatcher.class);
    private static final int MAX_MESSAGE_SIZE = NetworkSettings.MAX_MESSAGE_SIZE.getValue();
    private final ReceiptMap receiptMap = new ReceiptMap(512);
    protected final Context context;
    private final DefaultMessageHandler defaultHandler;
    private final PingRequestHandler pingHandler;
    private final FindNodeRequestHandler findNodeHandler;
    private final FindValueRequestHandler findValueHandler;
    private final StoreRequestHandler storeHandler;
    private final StatsRequestHandler statsHandler;
    private ScheduledFuture cleanupTaskFuture;
    private final List<MessageDispatcherListener> listeners = new CopyOnWriteArrayList<MessageDispatcherListener>();

    public MessageDispatcher(Context context) {
        this.context = context;
        this.defaultHandler = new DefaultMessageHandler(context);
        this.pingHandler = new PingRequestHandler(context);
        this.findNodeHandler = new FindNodeRequestHandler(context);
        this.findValueHandler = new FindValueRequestHandler(context, this.findNodeHandler);
        this.storeHandler = new StoreRequestHandler(context);
        this.statsHandler = new StatsRequestHandler(context);
    }

    public void addMessageDispatcherListener(MessageDispatcherListener messageDispatcherListener) {
        if (messageDispatcherListener == null) {
            throw new NullPointerException("MessageDispatcherListener is null");
        }
        this.listeners.add(messageDispatcherListener);
    }

    public void removeMessageDispatcherListener(MessageDispatcherListener messageDispatcherListener) {
        if (messageDispatcherListener == null) {
            throw new NullPointerException("MessageDispatcherListener is null");
        }
        this.listeners.remove(messageDispatcherListener);
    }

    public abstract void bind(SocketAddress var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ReceiptMap receiptMap = this.receiptMap;
        synchronized (receiptMap) {
            if (this.cleanupTaskFuture == null) {
                long l = NetworkSettings.CLEANUP_RECEIPTS_DELAY.getValue();
                Runnable runnable = new Runnable(){

                    public void run() {
                        MessageDispatcher.this.process(new CleanupProcessor());
                    }
                };
                this.cleanupTaskFuture = this.context.getDHTExecutorService().scheduleWithFixedDelay(runnable, 0L, l, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ReceiptMap receiptMap = this.receiptMap;
        synchronized (receiptMap) {
            if (this.cleanupTaskFuture != null) {
                this.cleanupTaskFuture.cancel(true);
                this.cleanupTaskFuture = null;
            }
        }
    }

    public void close() {
        this.stop();
        this.clear();
    }

    public boolean isAccepting() {
        return true;
    }

    public abstract boolean isBound();

    public abstract boolean isRunning();

    public boolean send(Contact contact, ResponseMessage responseMessage) throws IOException {
        return this.send(new Tag(contact, responseMessage));
    }

    public boolean send(SocketAddress socketAddress, RequestMessage requestMessage, ResponseHandler responseHandler) throws IOException {
        return this.send(new Tag(socketAddress, requestMessage, responseHandler));
    }

    public boolean send(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, ResponseHandler responseHandler) throws IOException {
        return this.send(new Tag(kUID, socketAddress, requestMessage, responseHandler));
    }

    public boolean send(Contact contact, RequestMessage requestMessage, ResponseHandler responseHandler) throws IOException {
        return this.send(new Tag(contact, requestMessage, responseHandler));
    }

    protected boolean send(Tag tag) throws IOException {
        if (!this.isRunning()) {
            throw new IOException("Cannot send Message because MessageDispatcher is not running");
        }
        KUID kUID = tag.getNodeID();
        SocketAddress socketAddress = tag.getSocketAddress();
        DHTMessage dHTMessage = tag.getMessage();
        if (this.context.isLocalContactAddress(socketAddress)) {
            String string = "Cannot send Message of type " + dHTMessage.getClass().getName() + " to " + ContactUtils.toString(kUID, socketAddress) + " because it has the same contact address as the local Node " + this.context.getLocalNode() + " has";
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)string);
            }
            this.process(new ErrorProcessor(tag, new IOException(string)));
            return false;
        }
        if (this.context.isLocalNodeID(kUID) && !MessageUtils.isCollisionPingRequest(this.context.getLocalNodeID(), dHTMessage)) {
            String string = "Cannot send Message of type " + dHTMessage.getClass().getName() + " to " + ContactUtils.toString(kUID, socketAddress) + " which is equal to our local Node " + this.context.getLocalNode();
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)string);
            }
            this.process(new ErrorProcessor(tag, new IOException(string)));
            return false;
        }
        if (!NetworkUtils.isValidSocketAddress((SocketAddress)socketAddress)) {
            String string = "Invalid IP:Port " + ContactUtils.toString(kUID, socketAddress);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)string);
            }
            this.process(new ErrorProcessor(tag, new IllegalSocketAddressException(string)));
            return false;
        }
        if (ContactUtils.isPrivateAddress(socketAddress)) {
            String string = "Private IP:Port " + ContactUtils.toString(kUID, socketAddress);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)string);
            }
            this.process(new ErrorProcessor(tag, new IllegalSocketAddressException(string)));
            return false;
        }
        ByteBuffer byteBuffer = this.serialize(socketAddress, dHTMessage);
        int n = byteBuffer.remaining();
        if (n <= 0) {
            this.process(new ErrorProcessor(tag, new IOException("Illegal Message size: " + n)));
            return false;
        }
        if (n >= MAX_MESSAGE_SIZE && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Message (" + dHTMessage.getClass().getName() + ") is too large: " + n + " >= " + MAX_MESSAGE_SIZE));
        }
        tag.setData(byteBuffer);
        this.process(new SubmitProcessor(tag));
        return true;
    }

    protected abstract boolean submit(Tag var1);

    protected ByteBuffer serialize(SocketAddress socketAddress, DHTMessage dHTMessage) throws IOException {
        return this.context.getMessageFactory().writeMessage(socketAddress, dHTMessage);
    }

    protected DHTMessage deserialize(SocketAddress socketAddress, ByteBuffer byteBuffer) throws MessageFormatException, IOException {
        return this.context.getMessageFactory().createMessage(socketAddress, byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(DHTMessage dHTMessage) {
        if (!this.isAccepting()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Dropping " + dHTMessage + " because MessageDispatcher is " + "not accepting requests nor responses"));
            }
            return;
        }
        Contact contact = dHTMessage.getContact();
        KUID kUID = contact.getNodeID();
        SocketAddress socketAddress = contact.getContactAddress();
        MessageID messageID = dHTMessage.getMessageID();
        if (this.context.isLocalContactAddress(socketAddress) || this.context.isLocalNodeID(kUID) && !(dHTMessage instanceof PingResponse)) {
            if (LOG.isErrorEnabled()) {
                String string = "Received a message of type " + dHTMessage.getClass().getName() + " from " + contact + " which is equal to our local Node " + this.context.getLocalNode();
                LOG.error((Object)string);
            }
            return;
        }
        if (!NetworkUtils.isValidSocketAddress((SocketAddress)socketAddress)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(contact + " has an invalid IP:Port"));
            }
            return;
        }
        if (!ContactUtils.isSameAddressSpace(this.context.getLocalNode(), contact)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(contact + " is from a different IP address space than local Node"));
            }
            return;
        }
        this.fireMessageReceived(dHTMessage);
        if (!this.accept(dHTMessage)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Dropping message from " + contact));
            }
            this.fireMessageFiltered(dHTMessage);
            return;
        }
        if (dHTMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)dHTMessage;
            if (contact.isFirewalled() && NetworkSettings.DROP_RESPONE_IF_FIREWALLED.getValue()) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Dropping " + dHTMessage + " because sender is firewalled"));
                }
                return;
            }
            if (messageID.isTaggingSupported() && !messageID.isFor(socketAddress)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)(responseMessage.getContact() + " sent us an unsolicited response: " + responseMessage));
                }
                return;
            }
            Tag.Receipt receipt = null;
            ReceiptMap receiptMap = this.receiptMap;
            synchronized (receiptMap) {
                receipt = (Tag.Receipt)this.receiptMap.get(messageID);
                if (receipt != null) {
                    receipt.received();
                    if (!receipt.sanityCheck(responseMessage)) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Response from " + responseMessage.getContact() + " did not pass the sanity check"));
                        }
                        return;
                    }
                    dHTMessage.getContact().setRoundTripTime(receipt.time());
                    this.receiptMap.remove(messageID);
                }
            }
            if (receipt == null && !messageID.isTaggingSupported()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(responseMessage.getContact() + " sent us an unsolicited response: " + responseMessage));
                }
                return;
            }
            this.processResponse(receipt, responseMessage);
        } else if (dHTMessage instanceof RequestMessage) {
            if (this.context.getLocalNode().isFirewalled() && NetworkSettings.DROP_REQUEST_IF_FIREWALLED.getValue()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Local Node is firewalled, dropping " + dHTMessage));
                }
            } else {
                this.processRequest((RequestMessage)dHTMessage);
            }
        } else {
            throw new IllegalArgumentException(dHTMessage + " is neither instance of RequestMessage nor ResponseMessage!");
        }
    }

    private void processResponse(Tag.Receipt receipt, ResponseMessage responseMessage) {
        ResponseProcessor responseProcessor = new ResponseProcessor(receipt, responseMessage);
        if (responseMessage instanceof DHTSecureMessage) {
            this.verify((DHTSecureMessage)((Object)responseMessage), responseProcessor);
        } else {
            this.process(responseProcessor);
        }
    }

    private void processRequest(RequestMessage requestMessage) {
        RequestProcessor requestProcessor = new RequestProcessor(requestMessage);
        if (requestMessage instanceof DHTSecureMessage) {
            this.verify((DHTSecureMessage)((Object)requestMessage), requestProcessor);
        } else {
            this.process(requestProcessor);
        }
    }

    protected void register(Tag tag) {
        Tag.Receipt receipt = tag.receipt();
        if (receipt != null) {
            this.process(new RegisterProcessor(receipt));
        }
        this.fireMessageSent(tag.getNodeID(), tag.getSocketAddress(), tag.getMessage());
    }

    protected abstract void process(Runnable var1);

    protected abstract void verify(SecureMessage var1, SecureMessageCallback var2);

    protected boolean accept(DHTMessage dHTMessage) {
        return true;
    }

    protected boolean allow(DHTMessage dHTMessage) {
        HostFilter hostFilter = this.context.getHostFilter();
        if (hostFilter != null) {
            return hostFilter.allow(dHTMessage.getContact().getContactAddress());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        ReceiptMap receiptMap = this.receiptMap;
        synchronized (receiptMap) {
            this.receiptMap.clear();
        }
    }

    protected void handleError(Tag tag, IOException iOException) {
        this.process(new ErrorProcessor(tag, iOException));
    }

    protected void fireMessageSent(KUID kUID, SocketAddress socketAddress, DHTMessage dHTMessage) {
        this.fireMessageDispatcherEvent(kUID, socketAddress, dHTMessage, MessageDispatcherEvent.EventType.MESSAGE_SENT);
    }

    protected void fireMessageReceived(DHTMessage dHTMessage) {
        this.fireMessageDispatcherEvent(null, null, dHTMessage, MessageDispatcherEvent.EventType.MESSAGE_RECEIVED);
    }

    protected void fireMessageFiltered(DHTMessage dHTMessage) {
        this.fireMessageDispatcherEvent(null, null, dHTMessage, MessageDispatcherEvent.EventType.MESSAGE_FILTERED);
    }

    protected void fireLateResponse(DHTMessage dHTMessage) {
        this.fireMessageDispatcherEvent(null, null, dHTMessage, MessageDispatcherEvent.EventType.LATE_RESPONSE);
    }

    protected void fireReceiptTimeout(Tag.Receipt receipt) {
        this.fireMessageDispatcherEvent(receipt.getNodeID(), receipt.getSocketAddress(), receipt.getRequestMessage(), MessageDispatcherEvent.EventType.RECEIPT_TIMEOUT);
    }

    protected void fireReceiptEvicted(Tag.Receipt receipt) {
        this.fireMessageDispatcherEvent(receipt.getNodeID(), receipt.getSocketAddress(), receipt.getRequestMessage(), MessageDispatcherEvent.EventType.RECEIPT_EVICTED);
    }

    protected void fireMessageDispatcherEvent(KUID kUID, SocketAddress socketAddress, DHTMessage dHTMessage, MessageDispatcherEvent.EventType eventType) {
        if (this.listeners.isEmpty()) {
            return;
        }
        MessageDispatcherEvent messageDispatcherEvent = new MessageDispatcherEvent(this, kUID, socketAddress, dHTMessage, eventType);
        for (MessageDispatcherListener messageDispatcherListener : this.listeners) {
            messageDispatcherListener.handleMessageDispatcherEvent(messageDispatcherEvent);
        }
    }

    public static class MessageDispatcherEvent {
        private MessageDispatcher messageDispatcher;
        private KUID nodeId;
        private SocketAddress dst;
        private DHTMessage message;
        private EventType type;

        public MessageDispatcherEvent(MessageDispatcher messageDispatcher, KUID kUID, SocketAddress socketAddress, DHTMessage dHTMessage, EventType eventType) {
            this.nodeId = kUID;
            this.dst = socketAddress;
            this.message = dHTMessage;
            this.type = eventType;
        }

        public MessageDispatcher getMessageDispatcher() {
            return this.messageDispatcher;
        }

        public KUID getNodeID() {
            return this.nodeId;
        }

        public SocketAddress getSocketAddress() {
            return this.dst;
        }

        public DHTMessage getMessage() {
            return this.message;
        }

        public EventType getEventType() {
            return this.type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EventType {
            MESSAGE_SENT,
            MESSAGE_RECEIVED,
            MESSAGE_FILTERED,
            RECEIPT_TIMEOUT,
            RECEIPT_EVICTED,
            LATE_RESPONSE;

        }
    }

    public static interface MessageDispatcherListener {
        public void handleMessageDispatcherEvent(MessageDispatcherEvent var1);
    }

    private class ErrorProcessor
    implements Runnable {
        private final Tag tag;
        private final IOException exception;

        private ErrorProcessor(Tag tag, IOException iOException) {
            this.tag = tag;
            this.exception = iOException;
        }

        public void run() {
            this.tag.handleError(this.exception);
        }
    }

    private class TickProcessor
    implements Runnable {
        private final Tag.Receipt receipt;

        private TickProcessor(Tag.Receipt receipt) {
            this.receipt = receipt;
        }

        public void run() {
            this.receipt.handleTick();
        }
    }

    private class TimeoutProcessor
    implements Runnable {
        private final Tag.Receipt receipt;
        private final boolean timeout;

        private TimeoutProcessor(Tag.Receipt receipt, boolean bl) {
            this.receipt = receipt;
            this.timeout = bl;
        }

        public void run() {
            if (this.timeout) {
                MessageDispatcher.this.fireReceiptTimeout(this.receipt);
            } else {
                MessageDispatcher.this.fireReceiptEvicted(this.receipt);
            }
            try {
                KUID kUID = this.receipt.getNodeID();
                SocketAddress socketAddress = this.receipt.getSocketAddress();
                RequestMessage requestMessage = this.receipt.getRequestMessage();
                long l = this.receipt.time();
                MessageDispatcher.this.defaultHandler.handleTimeout(kUID, socketAddress, requestMessage, l);
                this.receipt.getResponseHandler().handleTimeout(kUID, socketAddress, requestMessage, l);
            }
            catch (IOException iOException) {
                this.receipt.handleError(iOException);
                LOG.error((Object)"ReceiptMap removeEldestEntry error: ", (Throwable)iOException);
            }
        }
    }

    private class RequestProcessor
    implements Runnable,
    SecureMessageCallback {
        private final RequestMessage request;

        private RequestProcessor(RequestMessage requestMessage) {
            this.request = requestMessage;
        }

        public void handleSecureMessage(SecureMessage secureMessage, boolean bl) {
            if (bl) {
                MessageDispatcher.this.process(this);
            } else if (LOG.isErrorEnabled()) {
                LOG.error((Object)(this.request.getContact() + " send us a secure request Message but the signatures do not match!"));
            }
        }

        public void run() {
            if (!MessageDispatcher.this.allow(this.request)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.request.getContact() + " refused"));
                }
                MessageDispatcher.this.fireMessageFiltered(this.request);
                return;
            }
            AbstractRequestHandler abstractRequestHandler = null;
            if (this.request instanceof PingRequest) {
                abstractRequestHandler = MessageDispatcher.this.pingHandler;
            } else if (this.request instanceof FindNodeRequest) {
                abstractRequestHandler = MessageDispatcher.this.findNodeHandler;
            } else if (this.request instanceof FindValueRequest) {
                abstractRequestHandler = MessageDispatcher.this.findValueHandler;
            } else if (this.request instanceof StoreRequest) {
                abstractRequestHandler = MessageDispatcher.this.storeHandler;
            } else if (this.request instanceof StatsRequest) {
                abstractRequestHandler = MessageDispatcher.this.statsHandler;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There is no handler for " + this.request));
            }
            if (abstractRequestHandler != null) {
                try {
                    abstractRequestHandler.handleRequest(this.request);
                    MessageDispatcher.this.defaultHandler.handleRequest(this.request);
                }
                catch (IOException iOException) {
                    LOG.error((Object)"An exception occured during processing the request", (Throwable)iOException);
                }
            }
        }
    }

    private class ResponseProcessor
    implements Runnable,
    SecureMessageCallback {
        private final Tag.Receipt receipt;
        private final ResponseMessage response;

        private ResponseProcessor(Tag.Receipt receipt, ResponseMessage responseMessage) {
            this.receipt = receipt;
            this.response = responseMessage;
        }

        public void handleSecureMessage(SecureMessage secureMessage, boolean bl) {
            if (bl) {
                MessageDispatcher.this.process(this);
            } else if (LOG.isErrorEnabled()) {
                LOG.error((Object)(this.response.getContact() + " send us a secure response Message but the signatures do not match!"));
            }
        }

        public void run() {
            if (this.receipt != null) {
                this.processResponse();
            } else {
                this.processLateResponse();
            }
        }

        private void processResponse() {
            try {
                MessageDispatcher.this.defaultHandler.handleResponse(this.response, this.receipt.time());
                this.receipt.getResponseHandler().handleResponse(this.response, this.receipt.time());
            }
            catch (IOException iOException) {
                this.receipt.handleError(iOException);
                LOG.error((Object)"An error occured dusring processing the response", (Throwable)iOException);
            }
        }

        private void processLateResponse() {
            Contact contact = this.response.getContact();
            if (LOG.isTraceEnabled()) {
                if (this.response instanceof PingResponse) {
                    LOG.trace((Object)("Received a late Pong from " + contact));
                } else if (this.response instanceof FindNodeResponse) {
                    LOG.trace((Object)("Received a late FindNode response from " + contact));
                } else if (this.response instanceof FindValueResponse) {
                    LOG.trace((Object)("Received a late FindValue response from " + contact));
                } else if (this.response instanceof StoreResponse) {
                    LOG.trace((Object)("Received a late Store response from " + contact));
                } else if (this.response instanceof StatsResponse) {
                    LOG.trace((Object)("Received a late Stats response from " + contact));
                }
            }
            MessageDispatcher.this.fireLateResponse(this.response);
            MessageDispatcher.this.defaultHandler.handleLateResponse(this.response);
        }
    }

    private class CleanupProcessor
    implements Runnable {
        private CleanupProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReceiptMap receiptMap = MessageDispatcher.this.receiptMap;
            synchronized (receiptMap) {
                MessageDispatcher.this.receiptMap.cleanup();
            }
        }
    }

    private class RegisterProcessor
    implements Runnable {
        private final Tag.Receipt receipt;

        private RegisterProcessor(Tag.Receipt receipt) {
            this.receipt = receipt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReceiptMap receiptMap = MessageDispatcher.this.receiptMap;
            synchronized (receiptMap) {
                MessageDispatcher.this.receiptMap.add(this.receipt);
            }
        }
    }

    private class SubmitProcessor
    implements Runnable {
        private final Tag tag;

        private SubmitProcessor(Tag tag) {
            this.tag = tag;
        }

        public void run() {
            MessageDispatcher.this.submit(this.tag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReceiptMap
    extends FixedSizeHashMap<MessageID, Tag.Receipt> {
        public ReceiptMap(int n) {
            super(n);
        }

        public void add(Tag.Receipt receipt) {
            this.put(receipt.getMessageID(), receipt);
        }

        public void cleanup() {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                Tag.Receipt receipt = (Tag.Receipt)iterator.next();
                if (receipt.isCancelled()) {
                    iterator.remove();
                    continue;
                }
                if (receipt.timeout()) {
                    receipt.received();
                    iterator.remove();
                    MessageDispatcher.this.process(new TimeoutProcessor(receipt, true));
                    continue;
                }
                MessageDispatcher.this.process(new TickProcessor(receipt));
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<MessageID, Tag.Receipt> entry) {
            Tag.Receipt receipt = entry.getValue();
            boolean bl = receipt.timeout();
            if (super.removeEldestEntry(entry) || bl) {
                receipt.received();
                MessageDispatcher.this.process(new TimeoutProcessor(receipt, bl));
                return true;
            }
            return false;
        }
    }
}

