/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.concurrent.SyncWrapper;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.exceptions.DHTTimeoutException;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.handler.response.PingResponseHandler;
import org.limewire.mojito.manager.BootstrapManager;
import org.limewire.mojito.manager.BootstrapWorker;
import org.limewire.mojito.manager.PingIteratorFactory;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.FindNodeResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.BootstrapSettings;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.RouteTableUtils;
import org.limewire.mojito.util.TimeAwareIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BootstrapProcess
implements DHTTask<BootstrapResult> {
    private static final Log LOG = LogFactory.getLog(BootstrapProcess.class);
    private OnewayExchanger<BootstrapResult, ExecutionException> exchanger;
    private final Context context;
    private final BootstrapManager manager;
    private final List<DHTTask<?>> tasks = new ArrayList();
    private final List<BootstrapWorker> workers = new ArrayList<BootstrapWorker>();
    private final SyncWrapper<Status> status = new SyncWrapper(null);
    private volatile boolean foundNewContacts = false;
    private int routeTableFailureCount;
    private boolean cancelled = false;
    private Iterator<KUID> bucketsToRefresh;
    private Contact node;
    private Set<? extends SocketAddress> dst;
    private long startTime = -1L;
    private final long waitOnLock;

    public BootstrapProcess(Context context, BootstrapManager bootstrapManager, Contact contact) {
        this.context = context;
        this.manager = bootstrapManager;
        this.node = contact;
        this.waitOnLock = BootstrapSettings.getWaitOnLock(true);
    }

    public BootstrapProcess(Context context, BootstrapManager bootstrapManager, Set<? extends SocketAddress> set) {
        this.context = context;
        this.manager = bootstrapManager;
        this.dst = set;
        this.waitOnLock = BootstrapSettings.getWaitOnLock(false);
    }

    @Override
    public long getWaitOnLockTimeout() {
        return this.waitOnLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(OnewayExchanger<BootstrapResult, ExecutionException> onewayExchanger) {
        Object object = this.status.getLock();
        synchronized (object) {
            if (this.status.get() != null) {
                return;
            }
            this.status.set((Object)Status.BOOTSTRAPPING);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("starting bootstrap " + this.getPercentage(this.context.getRouteTable()) + "% alive"));
        }
        if (onewayExchanger == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Starting ResponseHandler without an OnewayExchanger");
            }
            onewayExchanger = new OnewayExchanger(true);
        }
        this.exchanger = onewayExchanger;
        this.startTime = System.currentTimeMillis();
        if (this.node == null) {
            this.findInitialContact();
        } else {
            this.findNearestNodes();
        }
    }

    private void findInitialContact() {
        OnewayExchanger<PingResult, ExecutionException> onewayExchanger = new OnewayExchanger<PingResult, ExecutionException>(true){

            public synchronized void setValue(PingResult pingResult) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Found initial bootstrap Node: " + pingResult));
                }
                super.setValue((Object)pingResult);
                BootstrapProcess.this.handlePong(pingResult);
            }

            public synchronized void setException(ExecutionException executionException) {
                LOG.info((Object)"ExecutionException", (Throwable)executionException);
                super.setException((Throwable)executionException);
                BootstrapProcess.this.exchanger.setException((Throwable)executionException);
            }
        };
        PingResponseHandler pingResponseHandler = new PingResponseHandler(this.context, new PingIteratorFactory.SocketAddressPinger(this.dst));
        pingResponseHandler.setMaxErrors(0);
        this.start(pingResponseHandler, onewayExchanger);
    }

    private void handlePong(PingResult pingResult) {
        this.node = pingResult.getContact();
        this.findNearestNodes();
    }

    private void findNearestNodes() {
        OnewayExchanger<FindNodeResult, ExecutionException> onewayExchanger = new OnewayExchanger<FindNodeResult, ExecutionException>(true){

            public synchronized void setValue(FindNodeResult findNodeResult) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Found nearest Nodes: " + findNodeResult));
                }
                super.setValue((Object)findNodeResult);
                BootstrapProcess.this.handleNearestNodes(findNodeResult);
            }

            public synchronized void setException(ExecutionException executionException) {
                super.setException((Throwable)executionException);
                BootstrapProcess.this.handleExecutionException(executionException);
            }
        };
        FindNodeResponseHandler findNodeResponseHandler = new FindNodeResponseHandler(this.context, this.node, this.context.getLocalNodeID());
        this.start(findNodeResponseHandler, onewayExchanger);
    }

    void handleExecutionException(ExecutionException executionException) {
        LOG.info((Object)"ExecutionException", (Throwable)executionException);
        this.exchanger.setException((Throwable)executionException);
    }

    private void handleNearestNodes(FindNodeResult findNodeResult) {
        Collection<? extends Contact> collection = findNodeResult.getCollisions();
        if (!collection.isEmpty()) {
            this.checkCollisions(collection);
        } else {
            Collection<? extends Contact> collection2 = findNodeResult.getPath();
            if (collection2 == null || collection2.isEmpty()) {
                this.bootstrapped(false);
            } else if (collection2.size() == 1 && collection2.contains(this.context.getLocalNode())) {
                this.bootstrapped(false);
            } else {
                this.refreshAllBuckets();
            }
        }
    }

    private void checkCollisions(Collection<? extends Contact> collection) {
        OnewayExchanger<PingResult, ExecutionException> onewayExchanger = new OnewayExchanger<PingResult, ExecutionException>(true){

            public synchronized void setValue(PingResult pingResult) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)(BootstrapProcess.this.context.getLocalNode() + " collides with " + pingResult.getContact()));
                }
                super.setValue((Object)pingResult);
                BootstrapProcess.this.handleCollision(pingResult);
            }

            public synchronized void setException(ExecutionException executionException) {
                LOG.info((Object)"ExecutionException", (Throwable)executionException);
                super.setException((Throwable)executionException);
                Throwable throwable = executionException.getCause();
                if (throwable instanceof DHTTimeoutException) {
                    BootstrapProcess.this.refreshAllBuckets();
                } else {
                    BootstrapProcess.this.exchanger.setException((Throwable)executionException);
                }
            }
        };
        Contact contact = ContactUtils.createCollisionPingSender(this.context.getLocalNode());
        PingIteratorFactory.CollisionPinger collisionPinger = new PingIteratorFactory.CollisionPinger(this.context, contact, CollectionUtils.toSet(collection));
        PingResponseHandler pingResponseHandler = new PingResponseHandler(this.context, contact, collisionPinger);
        this.start(pingResponseHandler, onewayExchanger);
    }

    private void handleCollision(PingResult pingResult) {
        this.context.changeNodeID();
        this.findNearestNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAllBuckets() {
        this.routeTableFailureCount = 0;
        this.foundNewContacts = false;
        Collection<KUID> collection = this.getBucketsToRefresh();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Buckets to refresh: " + CollectionUtils.toString(collection)));
        }
        this.bucketsToRefresh = new TimeAwareIterable<KUID>(BootstrapSettings.BOOTSTRAP_TIMEOUT.getValue(), collection).iterator();
        for (int i = 0; i < BootstrapSettings.BOOTSTRAP_WORKERS.getValue(); ++i) {
            BootstrapWorker bootstrapWorker = new BootstrapWorker(this.context, this);
            BootstrapProcess bootstrapProcess = this;
            synchronized (bootstrapProcess) {
                this.workers.add(bootstrapWorker);
            }
            this.context.getDHTExecutorService().execute(bootstrapWorker);
        }
    }

    private Collection<KUID> getBucketsToRefresh() {
        List<KUID> list = CollectionUtils.toList(this.context.getRouteTable().getRefreshIDs(true));
        Collections.reverse(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KUID getNextBucket() {
        Object object;
        BootstrapProcess bootstrapProcess = this;
        synchronized (bootstrapProcess) {
            if (this.cancelled) {
                return null;
            }
            object = this.bucketsToRefresh;
            synchronized (object) {
                if (this.bucketsToRefresh.hasNext()) {
                    return this.bucketsToRefresh.next();
                }
            }
        }
        boolean bl = false;
        object = this.status.getLock();
        synchronized (object) {
            if (this.status.get() != Status.FINISHED) {
                this.status.set((Object)Status.FINISHED);
                bl = true;
            }
        }
        if (bl) {
            this.determinateIfBootstrapped();
        }
        return null;
    }

    private void handleStaleRouteTable() {
        LOG.debug((Object)"handling stale route table");
        this.context.getRouteTable().purge(RouteTable.PurgeMode.DROP_CACHE, RouteTable.PurgeMode.PURGE_CONTACTS, RouteTable.PurgeMode.MERGE_BUCKETS, RouteTable.PurgeMode.STATE_TO_UNKNOWN);
        this.findNearestNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshDone(int n, boolean bl) {
        this.foundNewContacts |= bl;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = this.status.getLock();
        synchronized (object) {
            boolean bl4 = false;
            switch ((Status)((Object)this.status.get())) {
                case BOOTSTRAPPING: 
                case RETRYING_BOOTSTRAP: {
                    this.routeTableFailureCount += n;
                    if (this.routeTableFailureCount < BootstrapSettings.MAX_BOOTSTRAP_FAILURES.getValue()) break;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("high failures: " + this.routeTableFailureCount));
                    }
                    bl4 = true;
                }
            }
            if (bl4) {
                switch ((Status)((Object)this.status.get())) {
                    case BOOTSTRAPPING: {
                        this.routeTableFailureCount = 0;
                        this.status.set((Object)Status.RETRYING_BOOTSTRAP);
                        bl2 = true;
                        break;
                    }
                    case RETRYING_BOOTSTRAP: {
                        bl3 = true;
                        this.status.set((Object)Status.FINISHED);
                    }
                }
            }
        }
        if (bl2) {
            this.handleStaleRouteTable();
        }
        if (bl3) {
            this.cancel();
            this.determinateIfBootstrapped();
        }
    }

    private void determinateIfBootstrapped() {
        boolean bl = false;
        float f = this.purgeAndGetPercenetage();
        if (f >= BootstrapSettings.IS_BOOTSTRAPPED_RATIO.getValue()) {
            bl = true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Bootstrapped: " + f + " >= " + BootstrapSettings.IS_BOOTSTRAPPED_RATIO.getValue() + " -> " + bl));
        }
        this.bootstrapped(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float purgeAndGetPercenetage() {
        RouteTable routeTable;
        RouteTable routeTable2 = routeTable = this.context.getRouteTable();
        synchronized (routeTable2) {
            routeTable.purge(RouteTable.PurgeMode.DROP_CACHE, RouteTable.PurgeMode.PURGE_CONTACTS, RouteTable.PurgeMode.MERGE_BUCKETS);
            return this.getPercentage(routeTable);
        }
    }

    private float getPercentage(RouteTable routeTable) {
        return RouteTableUtils.getPercentageOfAliveContacts(routeTable);
    }

    private void bootstrapped(boolean bl) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finishing bootstrapping: " + bl));
        }
        BootstrapResult.ResultType resultType = BootstrapResult.ResultType.BOOTSTRAP_FAILED;
        if (bl) {
            this.manager.setBootstrapped(true);
            resultType = BootstrapResult.ResultType.BOOTSTRAP_SUCCEEDED;
        }
        long l = System.currentTimeMillis() - this.startTime;
        this.exchanger.setValue((Object)new BootstrapResult(this.node, l, resultType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void start(DHTTask<T> dHTTask, OnewayExchanger<T, ExecutionException> onewayExchanger) {
        boolean bl = false;
        BootstrapProcess bootstrapProcess = this;
        synchronized (bootstrapProcess) {
            if (!this.cancelled) {
                this.tasks.add(dHTTask);
                bl = true;
            }
        }
        if (bl) {
            dHTTask.start(onewayExchanger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.status.set((Object)Status.FINISHED);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Canceling BootstrapProcess");
        }
        ArrayList arrayList = null;
        ArrayList<BootstrapWorker> arrayList2 = null;
        Iterator iterator = this;
        synchronized (iterator) {
            if (!this.cancelled) {
                arrayList = new ArrayList(this.tasks);
                this.tasks.clear();
                arrayList2 = new ArrayList<BootstrapWorker>(this.workers);
                this.workers.clear();
                this.cancelled = true;
            }
        }
        if (arrayList != null) {
            for (DHTTask object : arrayList) {
                object.cancel();
            }
        }
        if (arrayList2 != null) {
            for (BootstrapWorker bootstrapWorker : arrayList2) {
                bootstrapWorker.shutdown();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        BOOTSTRAPPING,
        RETRYING_BOOTSTRAP,
        FINISHED;

    }
}

