/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.result.FindNodeResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodeManager
extends AbstractManager<FindNodeResult> {
    private final Map<KUID, FindNodeFuture> futureMap = Collections.synchronizedMap(new HashMap());

    public FindNodeManager(Context context) {
        super(context);
    }

    public void init() {
        this.futureMap.clear();
    }

    public DHTFuture<FindNodeResult> lookup(KUID kUID) {
        return this.lookup(kUID, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFuture<FindNodeResult> lookup(KUID kUID, int n) {
        FindNodeFuture findNodeFuture = null;
        Map<KUID, FindNodeFuture> map = this.futureMap;
        synchronized (map) {
            findNodeFuture = this.futureMap.get(kUID);
            if (findNodeFuture == null) {
                FindNodeResponseHandler findNodeResponseHandler = this.createFindNodeResponseHandler(this.context, kUID, n);
                findNodeFuture = new FindNodeFuture(kUID, findNodeResponseHandler);
                this.futureMap.put(kUID, findNodeFuture);
                this.context.getDHTExecutorService().execute(findNodeFuture);
            }
        }
        return findNodeFuture;
    }

    protected FindNodeResponseHandler createFindNodeResponseHandler(Context context, KUID kUID, int n) {
        return new FindNodeResponseHandler(context, kUID, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindNodeFuture
    extends DHTFutureTask<FindNodeResult> {
        private final KUID lookupId;
        private final DHTTask<FindNodeResult> handler;

        public FindNodeFuture(KUID kUID, DHTTask<FindNodeResult> dHTTask) {
            super(FindNodeManager.this.context, dHTTask);
            this.lookupId = kUID;
            this.handler = dHTTask;
        }

        @Override
        protected void done() {
            FindNodeManager.this.futureMap.remove(this.lookupId);
        }

        public String toString() {
            return "FindNodeFuture: " + this.lookupId + ", " + this.handler;
        }
    }
}

