/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.response.PingResponseHandler;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.EntryImpl;

class PingIteratorFactory {
    private PingIteratorFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryPinger
    implements PingResponseHandler.PingIterator {
        private final Collection<? extends Map.Entry<KUID, ? extends SocketAddress>> entries;
        private final Iterator<? extends Map.Entry<KUID, ? extends SocketAddress>> it;

        public EntryPinger(KUID kUID, SocketAddress socketAddress) {
            this(Collections.singleton(new EntryImpl<KUID, SocketAddress>(kUID, socketAddress)));
        }

        public EntryPinger(Map.Entry<KUID, ? extends SocketAddress> entry) {
            this(Collections.singleton(entry));
        }

        public EntryPinger(Set<? extends Map.Entry<KUID, ? extends SocketAddress>> set) {
            if (set == null) {
                throw new NullPointerException("Set<Entry<KUID, SocketAddress>> is null");
            }
            for (Map.Entry<KUID, ? extends SocketAddress> entry : set) {
                if (entry == null) {
                    throw new NullPointerException("Entry<KUID, SocketAddress> is null");
                }
                if (entry.getValue() != null) continue;
                throw new NullPointerException("SocketAddress is null");
            }
            this.entries = set;
            this.it = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler pingResponseHandler) throws IOException {
            Map.Entry<KUID, ? extends SocketAddress> entry = this.it.next();
            KUID kUID = entry.getKey();
            SocketAddress socketAddress = entry.getValue();
            PingRequest pingRequest = context.getMessageHelper().createPingRequest(socketAddress);
            return context.getMessageDispatcher().send(kUID, socketAddress, pingRequest, pingResponseHandler);
        }

        public String toString() {
            return "EntryPinger: " + this.entries.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SocketAddressPinger
    implements PingResponseHandler.PingIterator {
        private final Set<? extends SocketAddress> hosts;
        private final Iterator<? extends SocketAddress> it;

        public SocketAddressPinger(SocketAddress socketAddress) {
            this(Collections.singleton(socketAddress));
        }

        public SocketAddressPinger(Set<? extends SocketAddress> set) {
            if (set == null) {
                throw new NullPointerException("Set<SocketAddress> is null");
            }
            for (SocketAddress socketAddress : set) {
                if (socketAddress != null) continue;
                throw new NullPointerException("SocketAddress is null");
            }
            this.hosts = set;
            this.it = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler pingResponseHandler) throws IOException {
            SocketAddress socketAddress = this.it.next();
            PingRequest pingRequest = context.getMessageHelper().createPingRequest(socketAddress);
            return context.getMessageDispatcher().send(null, socketAddress, pingRequest, pingResponseHandler);
        }

        public String toString() {
            return "SocketAddressPinger: " + this.hosts.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollisionPinger
    extends ContactPinger {
        private final Contact sender;

        public CollisionPinger(Context context, Contact contact, Contact contact2) {
            this(context, contact, Collections.singleton(contact2));
        }

        public CollisionPinger(Context context, Contact contact, Set<? extends Contact> set) {
            super(set);
            if (ContextSettings.ASSERT_COLLISION_PING.getValue()) {
                this.assertCollisionPing(context, contact, set);
            }
            this.sender = contact;
        }

        private void assertCollisionPing(Context context, Contact contact, Set<? extends Contact> set) {
            KUID kUID = context.getLocalNodeID();
            if (!ContactUtils.isCollisionPingSender(kUID, contact)) {
                throw new IllegalArgumentException(contact + " is not a valid collision ping Contact");
            }
            for (Contact contact2 : set) {
                if (kUID.equals(contact2.getNodeID())) continue;
                throw new IllegalArgumentException(contact2 + " must have the same ID as the local Node ID: " + kUID);
            }
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler pingResponseHandler) throws IOException {
            Contact contact = (Contact)this.it.next();
            KUID kUID = contact.getNodeID();
            SocketAddress socketAddress = contact.getContactAddress();
            PingRequest pingRequest = context.getMessageFactory().createPingRequest(this.sender, socketAddress);
            return context.getMessageDispatcher().send(kUID, socketAddress, pingRequest, pingResponseHandler);
        }

        @Override
        public String toString() {
            return "CollisionPinger: " + this.sender;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContactPinger
    implements PingResponseHandler.PingIterator {
        final Collection<? extends Contact> nodes;
        final Iterator<? extends Contact> it;

        public ContactPinger(Contact contact) {
            this(Collections.singleton(contact));
        }

        public ContactPinger(Set<? extends Contact> set) {
            if (set == null) {
                throw new NullPointerException("Set<Contact> is null");
            }
            for (Contact contact : set) {
                if (contact != null) continue;
                throw new NullPointerException("Contact is null");
            }
            this.nodes = set;
            this.it = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler pingResponseHandler) throws IOException {
            Contact contact = this.it.next();
            KUID kUID = contact.getNodeID();
            SocketAddress socketAddress = contact.getContactAddress();
            PingRequest pingRequest = context.getMessageHelper().createPingRequest(socketAddress);
            return context.getMessageDispatcher().send(kUID, socketAddress, pingRequest, pingResponseHandler);
        }

        public String toString() {
            return "ContactPinger: " + this.nodes;
        }
    }
}

