/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.handler.response.PingResponseHandler;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.manager.PingIteratorFactory;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.statistics.NetworkStatisticContainer;
import org.limewire.mojito.util.ContactUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingManager
extends AbstractManager<PingResult> {
    private final Map<SocketAddress, PingFuture> futureMap = Collections.synchronizedMap(new HashMap());
    private NetworkStatisticContainer networkStats;

    public PingManager(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    public void init() {
        this.futureMap.clear();
    }

    public DHTFuture<PingResult> ping(SocketAddress socketAddress) {
        PingIteratorFactory.SocketAddressPinger socketAddressPinger = new PingIteratorFactory.SocketAddressPinger(socketAddress);
        return this.ping(null, socketAddress, socketAddressPinger);
    }

    public DHTFuture<PingResult> pingAddresses(Set<? extends SocketAddress> set) {
        PingIteratorFactory.SocketAddressPinger socketAddressPinger = new PingIteratorFactory.SocketAddressPinger(set);
        return this.ping(null, null, socketAddressPinger);
    }

    public DHTFuture<PingResult> ping(Contact contact) {
        PingIteratorFactory.ContactPinger contactPinger = new PingIteratorFactory.ContactPinger(contact);
        return this.ping(null, contact.getContactAddress(), contactPinger);
    }

    public DHTFuture<PingResult> ping(KUID kUID, SocketAddress socketAddress) {
        PingIteratorFactory.EntryPinger entryPinger = new PingIteratorFactory.EntryPinger(kUID, socketAddress);
        return this.ping(null, socketAddress, entryPinger);
    }

    public DHTFuture<PingResult> ping(Set<? extends Contact> set) {
        PingIteratorFactory.ContactPinger contactPinger = new PingIteratorFactory.ContactPinger(set);
        return this.ping(null, null, contactPinger);
    }

    public DHTFuture<PingResult> collisionPing(Contact contact) {
        return this.collisionPing(contact.getContactAddress(), Collections.singleton(contact));
    }

    public DHTFuture<PingResult> collisionPing(Set<? extends Contact> set) {
        return this.collisionPing(null, set);
    }

    private DHTFuture<PingResult> collisionPing(SocketAddress socketAddress, Set<? extends Contact> set) {
        Contact contact = ContactUtils.createCollisionPingSender(this.context.getLocalNode());
        PingIteratorFactory.CollisionPinger collisionPinger = new PingIteratorFactory.CollisionPinger(this.context, contact, set);
        return this.ping(contact, socketAddress, collisionPinger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFuture<PingResult> ping(Contact contact, SocketAddress socketAddress, PingResponseHandler.PingIterator pingIterator) {
        PingFuture pingFuture = null;
        Map<SocketAddress, PingFuture> map = this.futureMap;
        synchronized (map) {
            PingFuture pingFuture2 = pingFuture = socketAddress != null ? this.futureMap.get(socketAddress) : null;
            if (pingFuture == null) {
                PingResponseHandler pingResponseHandler = new PingResponseHandler(this.context, contact, pingIterator);
                pingFuture = new PingFuture(socketAddress, pingResponseHandler);
                if (socketAddress != null) {
                    this.futureMap.put(socketAddress, pingFuture);
                }
                this.networkStats.PINGS_SENT.incrementStat();
                this.context.getDHTExecutorService().execute(pingFuture);
            }
        }
        return pingFuture;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PingFuture
    extends DHTFutureTask<PingResult> {
        private final SocketAddress key;

        public PingFuture(SocketAddress socketAddress, DHTTask<PingResult> dHTTask) {
            super(PingManager.this.context, dHTTask);
            this.key = socketAddress;
        }

        @Override
        protected void done() {
            if (this.key != null) {
                PingManager.this.futureMap.remove(this.key);
            }
        }

        @Override
        protected void fireFutureResult(PingResult pingResult) {
            ((PingManager)PingManager.this).networkStats.PINGS_OK.incrementStat();
            super.fireFutureResult(pingResult);
        }

        @Override
        protected void fireExecutionException(ExecutionException executionException) {
            ((PingManager)PingManager.this).networkStats.PINGS_FAILED.incrementStat();
            super.fireExecutionException(executionException);
        }
    }
}

