/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages;

import java.io.IOException;
import java.io.OutputStream;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public interface DHTMessage {
    public static final int F_DHT_MESSAGE = 68;

    public OpCode getOpCode();

    public Contact getContact();

    public MessageID getMessageID();

    public Version getMessageVersion();

    public void write(OutputStream var1) throws IOException;

    public int getLength();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpCode {
        PING_REQUEST(1),
        PING_RESPONSE(2),
        STORE_REQUEST(3),
        STORE_RESPONSE(4),
        FIND_NODE_REQUEST(5),
        FIND_NODE_RESPONSE(6),
        FIND_VALUE_REQUEST(7),
        FIND_VALUE_RESPONSE(8),
        STATS_REQUEST(9),
        STATS_RESPONSE(10);

        private final int opcode;
        private static OpCode[] OPCODES;

        private OpCode(int n2) {
            this.opcode = n2;
        }

        public int toByte() {
            return this.opcode;
        }

        public String toString() {
            return this.name() + " (" + this.toByte() + ")";
        }

        public static OpCode valueOf(int n) throws MessageFormatException {
            OpCode opCode = OPCODES[n % OPCODES.length];
            if (opCode != null && opCode.opcode == n) {
                return opCode;
            }
            throw new MessageFormatException("Unknown opcode: " + n);
        }

        static {
            OpCode[] opCodeArray = OpCode.values();
            OPCODES = new OpCode[opCodeArray.length];
            for (OpCode opCode : opCodeArray) {
                int n = opCode.opcode % OPCODES.length;
                if (OPCODES[n] != null) {
                    throw new IllegalStateException("OpCode collision: index=" + n + ", OPCODES=" + (Object)((Object)OPCODES[n]) + ", o=" + (Object)((Object)opCode));
                }
                OpCode.OPCODES[n] = opCode;
            }
        }
    }
}

