/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Random;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.security.AbstractSecurityToken;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageID
implements MessageID,
Comparable<DefaultMessageID> {
    private static final long serialVersionUID = -1477232241287654597L;
    public static final int LENGTH = 16;
    private static final Random GENERATOR = new Random();
    private static final byte[] RANDOM_PAD = new byte[4];
    private final byte[] messageId;
    private final int hashCode;
    private final MACCalculatorRepositoryManager macManager;

    private DefaultMessageID(byte[] byArray, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        if (byArray == null) {
            throw new NullPointerException("messageId cannot be null");
        }
        if (byArray.length != 16) {
            throw new IllegalArgumentException("MessageID must be 16 bytes long: " + byArray.length);
        }
        this.macManager = mACCalculatorRepositoryManager;
        this.messageId = byArray;
        this.hashCode = Arrays.hashCode(byArray);
    }

    public static DefaultMessageID createWithInputStream(InputStream inputStream, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws IOException {
        byte[] byArray = new byte[16];
        int n = -1;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
        return new DefaultMessageID(byArray, mACCalculatorRepositoryManager);
    }

    public static DefaultMessageID createWithBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return new DefaultMessageID(byArray2, null);
    }

    public static DefaultMessageID createWithSocketAddress(SocketAddress socketAddress, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        byte[] byArray = new byte[16];
        GENERATOR.nextBytes(byArray);
        if (socketAddress instanceof InetSocketAddress) {
            byte[] byArray2 = new MessageSecurityToken(new DHTTokenData(socketAddress), mACCalculatorRepositoryManager).getBytes();
            System.arraycopy(byArray2, 0, byArray, 0, 4);
        }
        return new DefaultMessageID(byArray, mACCalculatorRepositoryManager);
    }

    public static DefaultMessageID createWithHexString(String string) {
        return new DefaultMessageID(ArrayUtils.parseHexString(string), null);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.messageId, 0, this.messageId.length);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public byte[] getBytes() {
        return this.getBytes(0, new byte[this.messageId.length], 0, this.messageId.length);
    }

    @Override
    public byte[] getBytes(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.messageId, n, byArray, n2, n3);
        return byArray;
    }

    private SecurityToken getSecurityToken() throws InvalidSecurityTokenException {
        byte[] byArray = new byte[4];
        System.arraycopy(this.messageId, 0, byArray, 0, byArray.length);
        return new MessageSecurityToken(byArray, this.macManager);
    }

    @Override
    public boolean isTaggingSupported() {
        return true;
    }

    @Override
    public boolean isFor(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            return false;
        }
        try {
            SecurityToken securityToken = this.getSecurityToken();
            DHTTokenData dHTTokenData = new DHTTokenData(socketAddress);
            return securityToken.isFor((SecurityToken.TokenData)dHTTokenData);
        }
        catch (InvalidSecurityTokenException invalidSecurityTokenException) {
            return false;
        }
    }

    @Override
    public int compareTo(DefaultMessageID defaultMessageID) {
        int n = 0;
        for (int i = 0; i < this.messageId.length; ++i) {
            n = (this.messageId[i] & 0xFF) - (defaultMessageID.messageId[i] & 0xFF);
            if (n < 0) {
                return -1;
            }
            if (n <= 0) continue;
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultMessageID)) {
            return false;
        }
        return Arrays.equals(this.messageId, ((DefaultMessageID)object).messageId);
    }

    public String toHexString() {
        return ArrayUtils.toHexString(this.messageId);
    }

    public String toBinString() {
        return ArrayUtils.toBinString(this.messageId);
    }

    public String toString() {
        return "MessageID: " + this.toHexString();
    }

    static {
        GENERATOR.nextBytes(RANDOM_PAD);
    }

    public static class MessageSecurityToken
    extends AbstractSecurityToken {
        public MessageSecurityToken(byte[] byArray, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws InvalidSecurityTokenException {
            super(byArray, mACCalculatorRepositoryManager);
        }

        public MessageSecurityToken(DHTTokenData dHTTokenData, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
            super((SecurityToken.TokenData)dHTTokenData, mACCalculatorRepositoryManager);
        }

        protected byte[] getFromMAC(byte[] byArray, SecurityToken.TokenData tokenData) {
            return byArray;
        }

        public String toString() {
            return "MessageSecurityToken: " + ArrayUtils.toHexString(this.getBytes());
        }
    }

    public static class DHTTokenData
    extends AddressSecurityToken.AddressTokenData {
        private final SocketAddress addr;

        public DHTTokenData(SocketAddress socketAddress) {
            super(socketAddress);
            this.addr = socketAddress;
            for (int i = 0; i < RANDOM_PAD.length; ++i) {
                int n = i;
                this.data[n] = (byte)(this.data[n] ^ RANDOM_PAD[i]);
            }
        }

        public String toString() {
            return "DHTTokenData: " + ArrayUtils.toHexString(this.getData()) + " for " + this.addr;
        }
    }
}

