/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.impl.AbstractLookupRequest;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindValueRequestImpl
extends AbstractLookupRequest
implements FindValueRequest {
    private final Collection<KUID> secondaryKeys;
    private final DHTValueType valueType;

    public FindValueRequestImpl(Context context, Contact contact, MessageID messageID, KUID kUID, Collection<KUID> collection, DHTValueType dHTValueType) {
        super(context, DHTMessage.OpCode.FIND_VALUE_REQUEST, contact, messageID, Version.ZERO, kUID);
        this.secondaryKeys = collection;
        this.valueType = dHTValueType;
    }

    public FindValueRequestImpl(Context context, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        super(context, DHTMessage.OpCode.FIND_VALUE_REQUEST, socketAddress, messageID, version, messageInputStream);
        this.secondaryKeys = messageInputStream.readKUIDs();
        this.valueType = messageInputStream.readValueType();
    }

    @Override
    public Collection<KUID> getSecondaryKeys() {
        return this.secondaryKeys;
    }

    @Override
    public DHTValueType getDHTValueType() {
        return this.valueType;
    }

    @Override
    protected void writeBody(MessageOutputStream messageOutputStream) throws IOException {
        super.writeBody(messageOutputStream);
        messageOutputStream.writeKUIDs(this.getSecondaryKeys());
        messageOutputStream.writeDHTValueType(this.getDHTValueType());
    }

    public String toString() {
        return "FindValueRequest: " + this.lookupId;
    }
}

