/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.manager.BootstrapManager;
import org.limewire.mojito.result.FindNodeResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.BucketRefresherSettings;
import org.limewire.mojito.settings.KademliaSettings;

public class BucketRefresher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(BucketRefresher.class);
    private final Context context;
    private final RefreshTask refreshTask = new RefreshTask();
    private ScheduledFuture future;

    public BucketRefresher(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RefreshTask refreshTask = this.refreshTask;
        synchronized (refreshTask) {
            if (this.future == null) {
                long l;
                long l2 = l = BucketRefresherSettings.BUCKET_REFRESHER_DELAY.getValue();
                if (BucketRefresherSettings.UNIFORM_BUCKET_REFRESH_DISTRIBUTION.getValue()) {
                    l2 = l + (long)((double)l * Math.random());
                }
                this.future = this.context.getDHTExecutorService().scheduleWithFixedDelay(this, l2, l, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        RefreshTask refreshTask = this.refreshTask;
        synchronized (refreshTask) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.refreshTask.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RefreshTask refreshTask = this.refreshTask;
        synchronized (refreshTask) {
            BootstrapManager bootstrapManager;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Random bucket refresh");
            }
            BootstrapManager bootstrapManager2 = bootstrapManager = this.context.getBootstrapManager();
            synchronized (bootstrapManager2) {
                if (!bootstrapManager.isBootstrapped()) {
                    if (!bootstrapManager.isBootstrapping()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Bootstrap " + this.context.getName()));
                        }
                        DHTFutureAdapter<PingResult> dHTFutureAdapter = new DHTFutureAdapter<PingResult>(){

                            @Override
                            public void handleFutureSuccess(PingResult pingResult) {
                                BucketRefresher.this.context.bootstrap(pingResult.getContact());
                            }
                        };
                        DHTFuture<PingResult> dHTFuture = this.context.findActiveContact();
                        dHTFuture.addDHTFutureListener((DHTFutureListener<PingResult>)dHTFutureAdapter);
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info((Object)(this.context.getName() + " is bootstrapping"));
                    }
                    return;
                }
            }
            if (this.refreshTask.isDone()) {
                long l = BucketRefresherSettings.BUCKET_REFRESHER_PING_NEAREST.getValue();
                if (l > 0L) {
                    Collection<Contact> collection = this.context.getRouteTable().select(this.context.getLocalNodeID(), KademliaSettings.REPLICATION_PARAMETER.getValue(), RouteTable.SelectMode.ALL);
                    for (Contact contact : collection) {
                        if (this.context.isLocalNode(contact)) continue;
                        long l2 = contact.getTimeStamp();
                        if (System.currentTimeMillis() - l2 < l) continue;
                        this.context.ping(contact);
                    }
                }
                this.refreshTask.refresh();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshTask
    implements DHTFutureListener<FindNodeResult> {
        private Iterator<KUID> bucketIds = null;
        private DHTFuture<FindNodeResult> future = null;

        private RefreshTask() {
        }

        public synchronized boolean isDone() {
            return this.bucketIds == null || !this.bucketIds.hasNext();
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.bucketIds = null;
        }

        public synchronized boolean refresh() {
            Collection<KUID> collection = BucketRefresher.this.context.getRouteTable().getRefreshIDs(false);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(BucketRefresher.this.context.getName() + " has " + collection.size() + " Buckets to refresh"));
            }
            this.bucketIds = collection.iterator();
            return this.next();
        }

        private synchronized boolean next() {
            if (this.isDone()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(BucketRefresher.this.context.getName() + " finished Bucket refreshes"));
                }
                return false;
            }
            KUID kUID = this.bucketIds.next();
            this.future = BucketRefresher.this.context.lookup(kUID);
            this.future.addDHTFutureListener(this);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(BucketRefresher.this.context.getName() + " started a Bucket refresh lookup for " + kUID));
            }
            return true;
        }

        @Override
        public void handleFutureSuccess(FindNodeResult findNodeResult) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)findNodeResult);
            }
            if (!this.next()) {
                this.stop();
            }
        }

        @Override
        public void handleExecutionException(ExecutionException executionException) {
            LOG.error((Object)"ExecutionException", (Throwable)executionException);
            if (!this.next()) {
                this.stop();
            }
        }

        @Override
        public void handleCancellationException(CancellationException cancellationException) {
            LOG.debug((Object)"CancellationException", (Throwable)cancellationException);
            this.stop();
        }

        @Override
        public void handleInterruptedException(InterruptedException interruptedException) {
            LOG.debug((Object)"InterruptedException", (Throwable)interruptedException);
            this.stop();
        }
    }
}

