/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.io.Serializable;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.Contact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RouteTable
extends Serializable {
    public void add(Contact var1);

    public Contact get(KUID var1);

    public Contact select(KUID var1);

    public Collection<Contact> select(KUID var1, int var2, SelectMode var3);

    public void handleFailure(KUID var1, SocketAddress var2);

    public Collection<Contact> getContacts();

    public Collection<Contact> getActiveContacts();

    public Collection<Contact> getCachedContacts();

    public Bucket getBucket(KUID var1);

    public Collection<Bucket> getBuckets();

    public Collection<KUID> getRefreshIDs(boolean var1);

    public void clear();

    public void purge(long var1);

    public void purge(PurgeMode var1, PurgeMode ... var2);

    public int size();

    public boolean isLocalNode(Contact var1);

    public Contact getLocalNode();

    public void setContactPinger(ContactPinger var1);

    public void setNotifier(DHTExecutorService var1);

    public void addRouteTableListener(RouteTableListener var1);

    public void removeRouteTableListener(RouteTableListener var1);

    public static class RouteTableEvent {
        private final RouteTable routeTable;
        private final Bucket bucket;
        private final Bucket left;
        private final Bucket right;
        private final Contact existing;
        private final Contact node;
        private final EventType type;
        private final long timeStamp = System.currentTimeMillis();

        public RouteTableEvent(RouteTable routeTable, Bucket bucket, Bucket bucket2, Bucket bucket3, Contact contact, Contact contact2, EventType eventType) {
            this.routeTable = routeTable;
            this.bucket = bucket;
            this.left = bucket2;
            this.right = bucket3;
            this.existing = contact;
            this.node = contact2;
            this.type = eventType;
        }

        public RouteTable getRouteTable() {
            return this.routeTable;
        }

        public Bucket getBucket() {
            return this.bucket;
        }

        public Bucket getLeftBucket() {
            return this.left;
        }

        public Bucket getRightBucket() {
            return this.right;
        }

        public Contact getExistingContact() {
            return this.existing;
        }

        public Contact getContact() {
            return this.node;
        }

        public EventType getEventType() {
            return this.type;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EventType {
            ADD_ACTIVE_CONTACT,
            ADD_CACHED_CONTACT,
            REPLACE_CONTACT,
            UPDATE_CONTACT,
            REMOVE_CONTACT,
            CONTACT_CHECK,
            SPLIT_BUCKET,
            CLEAR;

        }
    }

    public static interface RouteTableListener {
        public void handleRouteTableEvent(RouteTableEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ContactPinger {
        public void ping(Contact var1, DHTFutureListener<PingResult> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PurgeMode {
        DROP_CACHE,
        PURGE_CONTACTS,
        MERGE_BUCKETS,
        STATE_TO_UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectMode {
        ALL,
        ALIVE,
        ALIVE_WITH_LOCAL;

    }
}

