/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = -4652316695244961502L;
    private static final Version[] VERSIONS = new Version[10];
    public static final int LENGTH = 2;
    public static final Version ZERO = new Version(0);
    private final int version;

    private Version(int n) {
        this.version = n;
    }

    public int getMajor() {
        return this.version >> 8 & 0xFF;
    }

    public int getMinor() {
        return this.version & 0xFF;
    }

    public int shortValue() {
        return this.version;
    }

    public int hashCode() {
        return this.version;
    }

    @Override
    public int compareTo(Version version) {
        return this.version - version.version;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        return this.version == ((Version)object).version;
    }

    public String toString() {
        return this.getMajor() + "." + this.getMinor();
    }

    public static synchronized Version valueOf(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Version is out of range (0x0000 - 0xFFFF): " + n);
        }
        int n2 = n % VERSIONS.length;
        Version version = VERSIONS[n2];
        if (version == null || version.version != n) {
            Version.VERSIONS[n2] = version = new Version(n);
        }
        return version;
    }

    public static Version valueOf(int n, int n2) {
        return Version.valueOf(n << 8 | n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            int n = this.version % VERSIONS.length;
            Version version = VERSIONS[n];
            if (version == null || version.version != this.version) {
                Version.VERSIONS[n] = version = this;
            }
            return version;
        }
    }
}

