/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.collection.TrieUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.FixedSizeHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BucketNode
implements Bucket {
    private static final long serialVersionUID = -4116522147032657308L;
    private final RouteTable routeTable;
    private final KUID bucketId;
    private final int depth;
    private final PatriciaTrie<KUID, Contact> nodeTrie;
    private transient Map<KUID, Contact> cache;
    private transient ClassfulNetworkCounter counter;
    private long timeStamp = 0L;

    public BucketNode(RouteTable routeTable, KUID kUID, int n) {
        this.routeTable = routeTable;
        this.bucketId = kUID;
        this.depth = n;
        this.nodeTrie = new PatriciaTrie(KUID.KEY_ANALYZER);
        this.init();
    }

    private void init() {
        this.cache = Collections.emptyMap();
        this.counter = new ClassfulNetworkCounter(this);
    }

    void postInit() {
        for (Contact contact : this.nodeTrie.values()) {
            this.counter.incrementAndGet(contact);
        }
    }

    @Override
    public KUID getBucketID() {
        return this.bucketId;
    }

    public RouteTable getRouteTable() {
        return this.routeTable;
    }

    @Override
    public boolean isLocalNode(Contact contact) {
        return this.routeTable.isLocalNode(contact);
    }

    @Override
    public ClassfulNetworkCounter getClassfulNetworkCounter() {
        return this.counter;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void touch() {
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void addActiveContact(Contact contact) {
        this.checkNodeID(contact);
        assert (!this.isActiveFull());
        Contact contact2 = (Contact)this.nodeTrie.put((Object)contact.getNodeID(), (Object)contact);
        assert (contact2 == null);
        if (contact.isAlive()) {
            this.touch();
        }
        this.counter.incrementAndGet(contact);
    }

    @Override
    public Contact addCachedContact(Contact contact) {
        this.checkNodeID(contact);
        if (this.cache == Collections.EMPTY_MAP) {
            int n = RouteTableSettings.MAX_CACHE_SIZE.getValue();
            this.cache = new FixedSizeHashMap<KUID, Contact>(n / 2, 0.75f, true, n);
        }
        if (!this.isCacheFull()) {
            Contact contact2 = this.cache.put(contact.getNodeID(), contact);
            assert (contact2 == null);
        } else {
            Contact contact3 = this.getLeastRecentlySeenCachedContact();
            if (!contact3.isAlive() || !contact3.hasBeenRecentlyAlive() && contact.isAlive()) {
                Contact contact4 = this.cache.remove(contact3.getNodeID());
                assert (contact4 == contact3);
                this.cache.put(contact.getNodeID(), contact);
                return contact4;
            }
        }
        return null;
    }

    @Override
    public Contact updateContact(Contact contact) {
        this.checkNodeID(contact);
        KUID kUID = contact.getNodeID();
        if (this.containsActiveContact(kUID)) {
            Contact contact2 = (Contact)this.nodeTrie.put((Object)kUID, (Object)contact);
            assert (contact2 != null);
            this.counter.decrementAndGet(contact2);
            this.counter.incrementAndGet(contact);
            return contact2;
        }
        if (this.containsCachedContact(kUID)) {
            return this.cache.put(kUID, contact);
        }
        throw new IllegalStateException(contact + " is not in this Bucket " + this.toString());
    }

    private void checkNodeID(Contact contact) {
        if (this.depth <= 0) {
            return;
        }
        int n = this.bucketId.bitIndex(contact.getNodeID());
        if (n < 0) {
            return;
        }
        assert (n >= this.depth) : "Wrong Bucket";
    }

    @Override
    public Contact get(KUID kUID) {
        Contact contact = this.getActiveContact(kUID);
        if (contact == null) {
            contact = this.getCachedContact(kUID);
        }
        return contact;
    }

    @Override
    public Contact getActiveContact(KUID kUID) {
        return (Contact)this.nodeTrie.get((Object)kUID);
    }

    @Override
    public Contact getCachedContact(KUID kUID) {
        return this.cache.get(kUID);
    }

    @Override
    public Contact select(KUID kUID) {
        return (Contact)this.nodeTrie.select((Object)kUID);
    }

    @Override
    public Collection<Contact> select(KUID kUID, int n) {
        return TrieUtils.select(this.nodeTrie, (Object)kUID, (int)n);
    }

    @Override
    public boolean remove(KUID kUID) {
        if (this.removeActiveContact(kUID)) {
            return true;
        }
        return this.removeCachedContact(kUID);
    }

    @Override
    public boolean removeActiveContact(KUID kUID) {
        Contact contact = (Contact)this.nodeTrie.remove((Object)kUID);
        if (contact != null) {
            int n = this.counter.get(contact);
            int n2 = this.counter.decrementAndGet(contact);
            assert (n2 < n) : n2 + " < " + n + ", " + kUID + ", " + contact + this;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCachedContact(KUID kUID) {
        if (this.cache.remove(kUID) != null) {
            if (this.cache.isEmpty()) {
                this.cache = Collections.emptyMap();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(KUID kUID) {
        if (this.containsActiveContact(kUID)) {
            return true;
        }
        return this.containsCachedContact(kUID);
    }

    @Override
    public boolean containsActiveContact(KUID kUID) {
        return this.nodeTrie.containsKey((Object)kUID);
    }

    @Override
    public boolean containsCachedContact(KUID kUID) {
        return this.cache.containsKey(kUID);
    }

    @Override
    public boolean isActiveFull() {
        return this.nodeTrie.size() >= this.getMaxActiveSize();
    }

    @Override
    public boolean isCacheFull() {
        return !this.cache.isEmpty() && ((FixedSizeHashMap)this.cache).isFull();
    }

    @Override
    public boolean isTooDeep() {
        return this.depth % RouteTableSettings.DEPTH_LIMIT.getValue() == 0;
    }

    @Override
    public Collection<Contact> getActiveContacts() {
        return this.nodeTrie.values();
    }

    @Override
    public Collection<Contact> getCachedContacts() {
        return this.cache.values();
    }

    @Override
    public Contact getLeastRecentlySeenActiveContact() {
        final Contact[] contactArray = new Contact[]{null};
        this.nodeTrie.traverse((Trie.Cursor)new Trie.Cursor<KUID, Contact>(){

            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Contact> entry) {
                Contact contact = entry.getValue();
                Contact contact2 = contactArray[0];
                if (contact2 == null || contact.getTimeStamp() < contact2.getTimeStamp()) {
                    contactArray[0] = contact;
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return contactArray[0];
    }

    @Override
    public Contact getMostRecentlySeenActiveContact() {
        final Contact[] contactArray = new Contact[]{null};
        this.nodeTrie.traverse((Trie.Cursor)new Trie.Cursor<KUID, Contact>(){

            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Contact> entry) {
                Contact contact = entry.getValue();
                Contact contact2 = contactArray[0];
                if (contact2 == null || contact.getTimeStamp() > contact2.getTimeStamp()) {
                    contactArray[0] = contact;
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return contactArray[0];
    }

    @Override
    public void purge() {
        Object object = this.nodeTrie.values().iterator();
        while (object.hasNext()) {
            Contact contact = (Contact)object.next();
            if (contact.isAlive() || this.isLocalNode(contact)) continue;
            object.remove();
        }
        if (!this.isActiveFull() && !this.cache.isEmpty()) {
            object = new ArrayList<Contact>(this.getCachedContacts());
            for (int i = object.size() - 1; i >= 0 && !this.isActiveFull(); --i) {
                Contact contact = (Contact)object.get(i);
                if (contact.isAlive()) {
                    this.nodeTrie.put((Object)contact.getNodeID(), (Object)contact);
                }
                boolean bl = this.removeCachedContact(contact.getNodeID());
                assert (bl);
            }
        }
    }

    @Override
    public Contact getLeastRecentlySeenCachedContact() {
        if (this.getCachedContacts().isEmpty()) {
            return null;
        }
        return this.getCachedContacts().iterator().next();
    }

    @Override
    public Contact getMostRecentlySeenCachedContact() {
        Contact contact = null;
        Iterator<Contact> iterator = this.getCachedContacts().iterator();
        while (iterator.hasNext()) {
            Contact contact2;
            contact = contact2 = iterator.next();
        }
        return contact;
    }

    @Override
    public List<Bucket> split() {
        assert (this.getCachedContacts().isEmpty());
        BucketNode bucketNode = new BucketNode(this.routeTable, this.bucketId, this.depth + 1);
        BucketNode bucketNode2 = new BucketNode(this.routeTable, this.bucketId.set(this.depth), this.depth + 1);
        for (Contact contact : this.getActiveContacts()) {
            KUID kUID = contact.getNodeID();
            if (!kUID.isBitSet(this.depth)) {
                bucketNode.addActiveContact(contact);
                continue;
            }
            bucketNode2.addActiveContact(contact);
        }
        assert (bucketNode.size() + bucketNode2.size() == this.size());
        return Arrays.asList(bucketNode, bucketNode2);
    }

    @Override
    public int size() {
        return this.getActiveSize() + this.getCacheSize();
    }

    @Override
    public int getActiveSize() {
        return this.nodeTrie.size();
    }

    @Override
    public int getMaxActiveSize() {
        return KademliaSettings.REPLICATION_PARAMETER.getValue();
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    @Override
    public boolean isRefreshRequired() {
        return System.currentTimeMillis() - this.getTimeStamp() >= RouteTableSettings.BUCKET_REFRESH_PERIOD.getValue();
    }

    @Override
    public void clear() {
        this.nodeTrie.clear();
        this.cache = Collections.emptyMap();
    }

    public int hashCode() {
        return this.bucketId.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BucketNode)) {
            return false;
        }
        BucketNode bucketNode = (BucketNode)object;
        return this.bucketId.equals(bucketNode.bucketId) && this.depth == bucketNode.depth;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.bucketId).append(" (depth=").append(this.getDepth()).append(", active=").append(this.getActiveSize()).append(", cache=").append(this.getCacheSize()).append(")\n");
        Iterator<Contact> iterator = this.getActiveContacts().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringBuilder.append(" ").append(n).append(": ").append(iterator.next()).append("\n");
            ++n;
        }
        if (!this.getCachedContacts().isEmpty()) {
            stringBuilder.append("---\n");
            iterator = this.getCachedContacts().iterator();
            n = 0;
            while (iterator.hasNext()) {
                stringBuilder.append(" ").append(n).append(": ").append(iterator.next()).append("\n");
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }
}

