/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.security;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.limewire.mojito.Context;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.SecuritySettings;
import org.limewire.security.SecurityToken;

public class SecurityTokenHelper {
    private static final int SUBSTITUTE_PORT = 1024;
    private final Context context;

    public SecurityTokenHelper(Context context) {
        this.context = context;
    }

    private SocketAddress getTokenSocketAddress(Contact contact) {
        if (!contact.isFirewalled() || !SecuritySettings.SUBSTITUTE_TOKEN_PORT.getValue()) {
            return contact.getContactAddress();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)contact.getContactAddress();
        InetAddress inetAddress = inetSocketAddress.getAddress();
        return new InetSocketAddress(inetAddress, 1024);
    }

    public SecurityToken createSecurityToken(Contact contact) {
        return this.context.getSecurityTokenProvider().getSecurityToken(this.getTokenSocketAddress(contact));
    }

    public SecurityToken.TokenData createTokenData(Contact contact) {
        return this.context.getSecurityTokenProvider().getTokenData(this.getTokenSocketAddress(contact));
    }
}

