/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.statistics;

import java.io.IOException;
import java.io.Writer;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.statistics.SimpleStatistic;
import org.limewire.mojito.statistics.StatisticContainer;
import org.limewire.statistic.Statistic;

public class RoutingStatisticContainer
extends StatisticContainer {
    public Statistic NODE_COUNT = new SimpleStatistic();
    public Statistic LIVE_NODE_COUNT = new NodeCountStatistic();
    public Statistic UNKNOWN_NODE_COUNT = new NodeCountStatistic();
    public Statistic BUCKET_COUNT = new SimpleStatistic();
    public Statistic BUCKET_REFRESH_COUNT = new SimpleStatistic();
    public Statistic REPLACEMENT_COUNT = new SimpleStatistic();
    public Statistic DEAD_NODE_COUNT = new SimpleStatistic();
    public Statistic SPOOF_COUNT = new SimpleStatistic();

    public RoutingStatisticContainer(KUID kUID) {
        super(kUID);
    }

    public void writeStats(Writer writer) throws IOException {
        writer.write("Routing Stats:\n");
        super.writeStats(writer);
    }

    public static class Listener
    implements RouteTable.RouteTableListener {
        private RoutingStatisticContainer routingStats;

        public void handleRouteTableEvent(RouteTable.RouteTableEvent routeTableEvent) {
            if (this.routingStats == null) {
                RouteTable routeTable = routeTableEvent.getRouteTable();
                this.routingStats = new RoutingStatisticContainer(routeTable.getLocalNode().getNodeID());
            }
            if (routeTableEvent.getEventType().equals((Object)RouteTable.RouteTableEvent.EventType.ADD_ACTIVE_CONTACT)) {
                if (routeTableEvent.getContact().isAlive()) {
                    this.routingStats.LIVE_NODE_COUNT.incrementStat();
                } else {
                    this.routingStats.UNKNOWN_NODE_COUNT.incrementStat();
                }
            } else if (routeTableEvent.getEventType().equals((Object)RouteTable.RouteTableEvent.EventType.ADD_CACHED_CONTACT)) {
                this.routingStats.REPLACEMENT_COUNT.incrementStat();
            } else if (routeTableEvent.getEventType().equals((Object)RouteTable.RouteTableEvent.EventType.REMOVE_CONTACT)) {
                if (routeTableEvent.getContact().isDead()) {
                    this.routingStats.DEAD_NODE_COUNT.incrementStat();
                }
            } else if (routeTableEvent.getEventType().equals((Object)RouteTable.RouteTableEvent.EventType.REPLACE_CONTACT)) {
                this.routingStats.LIVE_NODE_COUNT.incrementStat();
                if (routeTableEvent.getContact().isDead()) {
                    this.routingStats.DEAD_NODE_COUNT.incrementStat();
                }
            } else if (routeTableEvent.getEventType().equals((Object)RouteTable.RouteTableEvent.EventType.SPLIT_BUCKET)) {
                this.routingStats.BUCKET_COUNT.incrementStat();
            }
        }
    }

    protected class NodeCountStatistic
    extends SimpleStatistic {
        protected NodeCountStatistic() {
        }

        public void incrementStat() {
            super.incrementStat();
            RoutingStatisticContainer.this.NODE_COUNT.incrementStat();
        }
    }
}

