/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.statistics;

import java.io.IOException;
import java.io.Writer;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.statistics.GlobalLookupStatisticContainer;
import org.limewire.mojito.statistics.StatisticContainer;

abstract class SingleLookupStatisticContainer
extends StatisticContainer {
    protected final KUID lookupKey;
    private final GlobalLookupStatisticContainer globalLookupStats;

    protected SingleLookupStatisticContainer(Context context, KUID kUID) {
        this.lookupKey = kUID;
        this.globalLookupStats = context.getGlobalLookupStats();
        this.globalLookupStats.addSingleLookupStatistic(this);
    }

    public void setHops(int n, boolean bl) {
        if (bl) {
            this.globalLookupStats.GLOBAL_FIND_VALUE_LOOKUP_HOPS.addData(n);
            this.globalLookupStats.GLOBAL_FIND_VALUE_LOOKUP_HOPS.storeCurrentStat();
        }
        this.globalLookupStats.GLOBAL_LOOKUP_HOPS.addData(n);
        this.globalLookupStats.GLOBAL_LOOKUP_HOPS.storeCurrentStat();
    }

    public void setTime(int n, boolean bl) {
        if (bl) {
            this.globalLookupStats.GLOBAL_FIND_VALUE_LOOKUP_TIME.addData(n);
            this.globalLookupStats.GLOBAL_FIND_VALUE_LOOKUP_TIME.storeCurrentStat();
        }
        this.globalLookupStats.GLOBAL_LOOKUP_TIME.addData(n);
        this.globalLookupStats.GLOBAL_LOOKUP_TIME.storeCurrentStat();
    }

    public void addRequest() {
        this.globalLookupStats.GLOBAL_LOOKUP_REQUESTS.incrementStat();
    }

    public void addReply() {
        this.globalLookupStats.GLOBAL_LOOKUP_REPLIES.incrementStat();
    }

    public void addTimeout() {
        this.globalLookupStats.GLOBAL_LOOKUP_TIMEOUTS.incrementStat();
    }

    public void writeStats(Writer writer) throws IOException {
        writer.write("Lookup: " + this.lookupKey + "\n");
        super.writeStats(writer);
    }
}

