/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.io.UnsupportedEncodingException;

public final class ArrayUtils {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] BIN = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};

    private ArrayUtils() {
    }

    public static String toHexString(byte[] byArray) {
        return ArrayUtils.toHexString(byArray, 0, byArray.length, -1);
    }

    public static String toHexString(byte[] byArray, int n) {
        return ArrayUtils.toHexString(byArray, 0, byArray.length, n);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        return ArrayUtils.toHexString(byArray, n, n2, -1);
    }

    public static String toHexString(byte[] byArray, int n, int n2, int n3) {
        int n4 = n + n2;
        if (n < 0 || n2 < 0 || n4 > byArray.length) {
            throw new IllegalArgumentException("offset=" + n + ", length=" + n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            if (n3 > 0 && n5 > n3) {
                stringBuilder.append("\n");
                n5 = 0;
            }
            stringBuilder.append(HEX[byArray[i] >> 4 & 0xF]).append(HEX[byArray[i] & 0xF]);
            n5 += 2;
        }
        return stringBuilder.toString();
    }

    public static String toBinString(byte[] byArray) {
        return ArrayUtils.toBinString(byArray, 0, byArray.length, -1);
    }

    public static String toBinString(byte[] byArray, int n) {
        return ArrayUtils.toBinString(byArray, 0, byArray.length, n);
    }

    public static String toBinString(byte[] byArray, int n, int n2) {
        return ArrayUtils.toBinString(byArray, n, n2, -1);
    }

    public static String toBinString(byte[] byArray, int n, int n2, int n3) {
        int n4 = n + n2;
        if (n < 0 || n2 < 0 || n4 > byArray.length) {
            throw new IllegalArgumentException("offset=" + n + ", length=" + n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * 8);
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            if (n3 > 0 && n5 >= n3) {
                stringBuilder.append("\n");
                n5 = 0;
            }
            stringBuilder.append(BIN[byArray[i] >> 4 & 0xF]).append(BIN[byArray[i] & 0xF]).append(" ");
            n5 += 9;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static byte[] parseHexString(String string) {
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = ArrayUtils.parseHexChar(string.charAt(n++));
            int n3 = ArrayUtils.parseHexChar(string.charAt(n++));
            byArray[i] = (byte)((n2 & 0xF) << 4 | n3 & 0xF);
        }
        return byArray;
    }

    private static int parseHexChar(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'A': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'B': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'C': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'D': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'E': {
                return 14;
            }
            case 'f': {
                return 15;
            }
            case 'F': {
                return 15;
            }
        }
        throw new NumberFormatException("Unknown digit: " + c);
    }

    public static int toInteger(String string) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        char[] cArray = string.toCharArray();
        if (cArray.length != 4) {
            throw new IllegalArgumentException("String must be 4 characters long");
        }
        int n = 0;
        for (char c : cArray) {
            n = n << 8 | c & 0xFF;
        }
        return n;
    }

    public static String toString(int n) {
        try {
            byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

