/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import com.google.inject.Inject;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.io.SimpleNetworkInstanceUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContactUtils {
    private static final Log LOG = LogFactory.getLog(ContactUtils.class);
    @Inject
    private static volatile NetworkInstanceUtils networkInstanceUtils = new SimpleNetworkInstanceUtils();
    public static final Comparator<Contact> CONTACT_MRS_COMPARATOR = new Comparator<Contact>(){

        @Override
        public int compare(Contact contact, Contact contact2) {
            return -ContactUtils.compareLong(contact.getTimeStamp(), contact2.getTimeStamp());
        }
    };
    public static final Comparator<Contact> CONTACT_ALIVE_TO_FAILED_COMPARATOR = new Comparator<Contact>(){

        @Override
        public int compare(Contact contact, Contact contact2) {
            if (!contact.hasFailed() && !contact2.hasFailed()) {
                return CONTACT_MRS_COMPARATOR.compare(contact, contact2);
            }
            if (contact.hasFailed() && !contact2.hasFailed()) {
                return 1;
            }
            if (!contact.hasFailed() && contact2.hasFailed()) {
                return -1;
            }
            return ContactUtils.compareLong(contact.getLastFailedTime(), contact2.getLastFailedTime());
        }
    };

    public static void setNetworkInstanceUtils(NetworkInstanceUtils networkInstanceUtils) {
        ContactUtils.networkInstanceUtils = networkInstanceUtils;
    }

    private static int compareLong(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    private ContactUtils() {
    }

    public static String toString(KUID kUID, SocketAddress socketAddress) {
        if (kUID != null) {
            if (socketAddress != null) {
                return kUID + " (" + socketAddress + ")";
            }
            return kUID.toString();
        }
        if (socketAddress != null) {
            return socketAddress.toString();
        }
        return "null";
    }

    public static boolean isLocalAddress(Contact contact) {
        return NetworkUtils.isLocalAddress((SocketAddress)contact.getContactAddress());
    }

    public static boolean areLocalContacts(Contact contact, Contact contact2) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)contact2.getContactAddress();
        InetSocketAddress inetSocketAddress2 = (InetSocketAddress)contact.getContactAddress();
        return NetworkUtils.isLocalAddress((SocketAddress)inetSocketAddress) && NetworkUtils.isLocalAddress((SocketAddress)inetSocketAddress2) && inetSocketAddress.getPort() == inetSocketAddress2.getPort();
    }

    public static boolean isValidSocketAddress(Contact contact) {
        return NetworkUtils.isValidSocketAddress((SocketAddress)contact.getContactAddress());
    }

    public static boolean isPrivateAddress(InetAddress inetAddress) {
        return networkInstanceUtils.isPrivateAddress(inetAddress);
    }

    public static boolean isPrivateAddress(SocketAddress socketAddress) {
        return networkInstanceUtils.isPrivateAddress(socketAddress);
    }

    public static boolean isPrivateAddress(Contact contact) {
        return ContactUtils.isPrivateAddress(contact.getContactAddress());
    }

    public static boolean isIPv4Address(Contact contact) {
        InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
        return inetAddress instanceof Inet4Address;
    }

    public static boolean isIPv4CompatibleAddress(Contact contact) {
        InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
        return inetAddress instanceof Inet6Address && ((Inet6Address)inetAddress).isIPv4CompatibleAddress();
    }

    public static int getClassC(Contact contact) {
        InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
        return NetworkUtils.getClassC((InetAddress)inetAddress);
    }

    public static boolean isPrivateIPv4CompatibleAddress(Contact contact) {
        InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
        return NetworkUtils.isPrivateIPv4CompatibleAddress((InetAddress)inetAddress);
    }

    public static boolean isSameNodeID(Contact contact, Contact contact2) {
        return contact.getNodeID().equals(contact2.getNodeID());
    }

    public static boolean isCollision(Context context, Contact contact) {
        return context.isLocalNodeID(contact.getNodeID()) && !context.isLocalContactAddress(contact.getContactAddress());
    }

    public static boolean isLocalContact(Context context, Contact contact) {
        if (context.isLocalNodeID(contact.getNodeID())) {
            return true;
        }
        if (context.isLocalContactAddress(contact.getContactAddress())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(contact + " has the same Contact addess as we do " + context.getLocalNode()));
            }
            return true;
        }
        return false;
    }

    public static boolean isSameAddressSpace(Contact contact, Contact contact2) {
        return NetworkUtils.isSameAddressSpace((SocketAddress)contact.getContactAddress(), (SocketAddress)contact2.getContactAddress());
    }

    public static Contact createCollisionPingSender(Contact contact) {
        if (!(contact instanceof LocalContact)) {
            throw new IllegalArgumentException("Contact must be an instance of LocalContact: " + contact);
        }
        Vendor vendor = contact.getVendor();
        Version version = contact.getVersion();
        KUID kUID = contact.getNodeID().invert();
        SocketAddress socketAddress = contact.getContactAddress();
        Contact contact2 = ContactFactory.createLiveContact(socketAddress, vendor, version, kUID, socketAddress, 0, 1);
        return contact2;
    }

    public static boolean isCollisionPingSender(KUID kUID, Contact contact) {
        if (!contact.isFirewalled()) {
            return false;
        }
        KUID kUID2 = kUID.invert();
        return kUID2.equals(contact.getNodeID());
    }

    public static <T extends Contact> Contact getMostRecentlySeen(Collection<T> collection) {
        List<T> list = CollectionUtils.toList(collection);
        assert (((Contact)list.get(0)).getTimeStamp() >= ((Contact)list.get(collection.size() - 1)).getTimeStamp());
        return (Contact)list.get(0);
    }

    public static <T extends Contact> Contact getLeastRecentlySeen(Collection<T> collection) {
        List<T> list = CollectionUtils.toList(collection);
        assert (((Contact)list.get(collection.size() - 1)).getTimeStamp() <= ((Contact)list.get(0)).getTimeStamp());
        return (Contact)list.get(collection.size() - 1);
    }

    public static <T extends Contact> Collection<T> sort(Collection<T> collection, int n) {
        return ContactUtils.sort(collection).subList(0, Math.min(n, collection.size()));
    }

    public static <T extends Contact> List<T> sort(Collection<T> collection) {
        List<T> list = CollectionUtils.toList(collection);
        Collections.sort(list, CONTACT_MRS_COMPARATOR);
        return list;
    }

    public static <T extends Contact> List<T> sortAliveToFailed(Collection<T> collection) {
        List<T> list = CollectionUtils.toList(collection);
        Collections.sort(list, CONTACT_ALIVE_TO_FAILED_COMPARATOR);
        return list;
    }
}

