/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.zip.GZIPInputStream;
import org.limewire.mojito.exceptions.SignatureVerificationException;
import org.limewire.util.Base32;

public final class CryptoUtils {
    public static final String KEY_ALGORITHM = "DSA";
    public static final int KEY_SIZE = 512;
    public static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    private static Signature SIGNATURE;

    private CryptoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey loadPublicKey(File file) throws IOException, SignatureException, InvalidKeyException {
        FileInputStream fileInputStream = null;
        GZIPInputStream gZIPInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            gZIPInputStream = new GZIPInputStream(fileInputStream);
            PublicKey publicKey = CryptoUtils.loadPublicKey(gZIPInputStream);
            return publicKey;
        }
        finally {
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey loadPublicKey(String string) throws IOException, SignatureException, InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base32.decode((String)string));
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            PublicKey publicKey = CryptoUtils.loadPublicKey(gZIPInputStream);
            return publicKey;
        }
        finally {
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
        }
    }

    public static PublicKey loadPublicKey(InputStream inputStream) throws IOException, SignatureException, InvalidKeyException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        byte[] byArray2 = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray2);
        PublicKey publicKey = CryptoUtils.createPublicKey(byArray2);
        if (!CryptoUtils.verify(publicKey, byArray, new byte[][]{byArray2})) {
            throw new SignatureVerificationException();
        }
        return publicKey;
    }

    public static PublicKey createPublicKey(byte[] byArray) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException(invalidKeySpecException);
        }
    }

    public static synchronized byte[] sign(PrivateKey privateKey, byte[] ... byArray) throws SignatureException, InvalidKeyException {
        try {
            if (SIGNATURE == null) {
                SIGNATURE = Signature.getInstance(SIGNATURE_ALGORITHM);
            }
            SIGNATURE.initSign(privateKey);
            for (byte[] byArray2 : byArray) {
                SIGNATURE.update(byArray2, 0, byArray2.length);
            }
            return SIGNATURE.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static synchronized boolean verify(PublicKey publicKey, byte[] byArray, byte[] ... byArray2) throws SignatureException, InvalidKeyException {
        if (byArray == null) {
            return false;
        }
        try {
            if (SIGNATURE == null) {
                SIGNATURE = Signature.getInstance(SIGNATURE_ALGORITHM);
            }
            SIGNATURE.initVerify(publicKey);
            for (byte[] byArray3 : byArray2) {
                SIGNATURE.update(byArray3, 0, byArray3.length);
            }
            return SIGNATURE.verify(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }
}

