/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.settings.KademliaSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTSizeEstimator {
    private static final Log LOG = LogFactory.getLog(DHTSizeEstimator.class);
    private static final BigInteger MAXIMUM = KUID.MAXIMUM.toBigInteger();
    private static final int MIN_NODE_COUNT = 3;
    private List<BigInteger> localSizeHistory = new LinkedList<BigInteger>();
    private List<BigInteger> remoteSizeHistory = new LinkedList<BigInteger>();
    private BigInteger estimatedSize = BigInteger.ZERO;
    private long localEstimateTime = 0L;
    private long updateEstimatedSizeTime = 0L;

    public synchronized void clear() {
        this.estimatedSize = BigInteger.ZERO;
        this.localEstimateTime = 0L;
        this.updateEstimatedSizeTime = 0L;
        this.localSizeHistory.clear();
        this.remoteSizeHistory.clear();
    }

    public synchronized BigInteger getEstimatedSize(RouteTable routeTable) {
        if (routeTable != null && System.currentTimeMillis() - this.localEstimateTime >= ContextSettings.ESTIMATE_NETWORK_SIZE_EVERY.getValue()) {
            RouteTable.SelectMode selectMode = RouteTable.SelectMode.ALL;
            if (ContextSettings.ESTIMATE_WITH_LIVE_NODES_ONLY.getValue()) {
                selectMode = RouteTable.SelectMode.ALIVE;
            }
            KUID kUID = routeTable.getLocalNode().getNodeID();
            Collection<Contact> collection = routeTable.select(kUID, KademliaSettings.REPLICATION_PARAMETER.getValue(), selectMode);
            this.updateSize(collection);
            this.localEstimateTime = System.currentTimeMillis();
        }
        return this.estimatedSize;
    }

    public synchronized void addEstimatedRemoteSize(BigInteger bigInteger) {
        if (!ContextSettings.COUNT_REMOTE_SIZE.getValue()) {
            this.remoteSizeHistory.clear();
            return;
        }
        if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
            return;
        }
        if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(MAXIMUM) > 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(bigInteger + " is an illegal argument"));
            }
            return;
        }
        this.remoteSizeHistory.add(bigInteger);
        int n = ContextSettings.MAX_REMOTE_HISTORY_SIZE.getValue();
        while (this.remoteSizeHistory.size() > n && !this.remoteSizeHistory.isEmpty()) {
            this.remoteSizeHistory.remove(0);
        }
    }

    public synchronized void updateSize(Collection<? extends Contact> collection) {
        if (System.currentTimeMillis() - this.updateEstimatedSizeTime >= ContextSettings.UPDATE_NETWORK_SIZE_EVERY.getValue() && collection.size() >= 3) {
            this.estimatedSize = this.computeSize(collection);
            this.updateEstimatedSizeTime = System.currentTimeMillis();
        }
    }

    public synchronized BigInteger computeSize(Collection<? extends Contact> collection) {
        BigInteger[] bigIntegerArray;
        Object object;
        Serializable serializable;
        Serializable serializable2;
        if (collection.size() < 3) {
            return BigInteger.ONE.max(BigInteger.valueOf(collection.size()));
        }
        Iterator<? extends Contact> iterator = collection.iterator();
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.ZERO;
        KUID kUID = iterator.next().getNodeID();
        int n = 1;
        while (iterator.hasNext()) {
            serializable2 = iterator.next();
            BigInteger bigInteger3 = kUID.xor(serializable2.getNodeID()).toBigInteger();
            serializable = BigInteger.valueOf(n);
            bigInteger = bigInteger.add(((BigInteger)serializable).multiply(bigInteger3));
            bigInteger2 = bigInteger2.add(((BigInteger)serializable).pow(2));
            ++n;
        }
        BigInteger bigInteger4 = BigInteger.ZERO;
        if (!bigInteger.equals(BigInteger.ZERO)) {
            bigInteger4 = KUID.MAXIMUM.toBigInteger().multiply(bigInteger2).divide(bigInteger);
        }
        bigInteger4 = BigInteger.ONE.max(bigInteger4);
        serializable2 = BigInteger.ZERO;
        this.localSizeHistory.add(bigInteger4);
        int n2 = ContextSettings.MAX_LOCAL_HISTORY_SIZE.getValue();
        while (this.localSizeHistory.size() > n2 && !this.localSizeHistory.isEmpty()) {
            this.localSizeHistory.remove(0);
        }
        if (!this.localSizeHistory.isEmpty()) {
            serializable = BigInteger.ZERO;
            object = this.localSizeHistory.iterator();
            while (object.hasNext()) {
                bigIntegerArray = object.next();
                serializable = ((BigInteger)serializable).add((BigInteger)bigIntegerArray);
            }
            serializable2 = ((BigInteger)serializable).divide(BigInteger.valueOf(this.localSizeHistory.size()));
        }
        serializable = serializable2;
        if (ContextSettings.COUNT_REMOTE_SIZE.getValue() && (object = new TreeSet<BigInteger>(this.remoteSizeHistory)).size() >= 3) {
            int n3;
            bigIntegerArray = object.toArray(new BigInteger[0]);
            int n4 = 1;
            for (int i = n3 = ContextSettings.SKIP_REMOTE_ESTIMATES.getValue(); n3 >= 0 && i < bigIntegerArray.length - n3; ++i) {
                serializable = ((BigInteger)serializable).add(bigIntegerArray[i]);
                ++n4;
            }
            serializable = ((BigInteger)serializable).divide(BigInteger.valueOf(n4));
            serializable = ((BigInteger)serializable).min(MAXIMUM);
        }
        return BigInteger.ONE.max((BigInteger)serializable);
    }
}

