/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import org.limewire.collection.FileComparator;
import org.limewire.collection.StringComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Comparators {
    private static final Comparator<Integer> INT_COMPARATOR = new IntComparator();
    private static final Comparator<Integer> INVERSE_INT_COMPARATOR = new InverseIntComparator();
    private static final Comparator<Long> LONG_COMPARATOR = new LongComparator();
    private static final Comparator<Long> INVERSE_LONG_COMPARATOR = new InverseLongComparator();
    private static final Comparator<String> STRING_COMPARATOR = new StringComparator();
    private static final Comparator<File> FILE_COMPARATOR = new FileComparator();
    private static final Comparator<String> CASE_INSENSITIVE_STRING_COMPARATOR = new CaseInsensitiveStringComparator();
    private static final Comparator<Double> INVERSE_DOUBLE_COMPARATOR = new Comparator<Double>(){

        @Override
        public int compare(Double d, Double d2) {
            return d2.compareTo(d);
        }
    };

    private Comparators() {
    }

    public static Comparator<Integer> integerComparator() {
        return INT_COMPARATOR;
    }

    public static Comparator<Integer> inverseIntegerComparator() {
        return INVERSE_INT_COMPARATOR;
    }

    public static Comparator<Long> longComparator() {
        return LONG_COMPARATOR;
    }

    public static Comparator<Long> inverseLongComparator() {
        return INVERSE_LONG_COMPARATOR;
    }

    public static Comparator<Double> inverseDoubleComparator() {
        return INVERSE_DOUBLE_COMPARATOR;
    }

    public static Comparator<String> stringComparator() {
        return STRING_COMPARATOR;
    }

    public static Comparator<File> fileComparator() {
        return FILE_COMPARATOR;
    }

    public static <T extends Comparable<T>> Comparator<T> naturalComparator(Class<? extends T> clazz) {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return t.compareTo(t2);
            }
        };
    }

    public static Comparator<String> caseInsensitiveStringComparator() {
        return CASE_INSENSITIVE_STRING_COMPARATOR;
    }

    public static int intCompareTo(Integer n, Integer n2) {
        int n3;
        int n4 = n;
        return n4 < (n3 = n2.intValue()) ? -1 : (n4 == n3 ? 0 : 1);
    }

    public static int longCompareTo(Long l, Long l2) {
        long l3;
        long l4 = l;
        return l4 < (l3 = l2.longValue()) ? -1 : (l4 == l3 ? 0 : 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CaseInsensitiveStringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 263123571237995212L;

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InverseLongComparator
    implements Comparator<Long>,
    Serializable {
        private static final long serialVersionUID = 316426787496198051L;

        private InverseLongComparator() {
        }

        @Override
        public int compare(Long l, Long l2) {
            return -Comparators.longCompareTo(l, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LongComparator
    implements Comparator<Long>,
    Serializable {
        private static final long serialVersionUID = 226428887996180051L;

        private LongComparator() {
        }

        @Override
        public int compare(Long l, Long l2) {
            return Comparators.longCompareTo(l, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InverseIntComparator
    implements Comparator<Integer> {
        private InverseIntComparator() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            return -Comparators.intCompareTo(n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntComparator
    implements Comparator<Integer>,
    Serializable {
        private static final long serialVersionUID = 830281396810831681L;

        private IntComparator() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            return Comparators.intCompareTo(n, n2);
        }
    }
}

