/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.limewire.collection.FixedSizeArrayHashMap;
import org.limewire.collection.RandomAccessCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeArrayHashSet<E>
extends HashSet<E>
implements RandomAccessCollection<E> {
    private transient FixedSizeArrayHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public FixedSizeArrayHashSet(int n) {
        this.map = new FixedSizeArrayHashMap(n);
    }

    public FixedSizeArrayHashSet(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public FixedSizeArrayHashSet(int n, Collection<? extends E> collection) {
        this(n);
        this.addAll(collection);
    }

    public FixedSizeArrayHashSet(int n, int n2, float f) {
        super(n2, f);
        this.map = new FixedSizeArrayHashMap(n);
    }

    public FixedSizeArrayHashSet(int n, int n2) {
        super(n2);
        this.map = new FixedSizeArrayHashMap(n);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object clone() {
        FixedSizeArrayHashSet fixedSizeArrayHashSet = (FixedSizeArrayHashSet)super.clone();
        fixedSizeArrayHashSet.map = (FixedSizeArrayHashMap)this.map.clone();
        return fixedSizeArrayHashSet;
    }

    @Override
    public E get(int n) {
        return this.map.getKeyAt(n);
    }
}

