/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.Comparator;
import org.limewire.collection.SortedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeSortedList<E>
extends SortedList<E> {
    private final int capacity;

    public FixedSizeSortedList(int n) {
        this.capacity = n;
    }

    public FixedSizeSortedList(Collection<? extends E> collection, Comparator<? super E> comparator, int n) {
        super(collection, comparator);
        this.capacity = n;
    }

    public FixedSizeSortedList(Collection<? extends E> collection, int n) {
        super(collection);
        this.capacity = n;
    }

    public FixedSizeSortedList(Comparator<? super E> comparator, int n) {
        super(comparator);
        this.capacity = n;
    }

    @Override
    public boolean add(E e) {
        if (this.size() == this.capacity) {
            this.remove(this.last());
        }
        return super.add(e);
    }

    public E insert(E e) {
        Object t = null;
        if (this.size() == this.capacity) {
            t = this.last();
            if (this.comparator().compare(e, t) < 0) {
                return e;
            }
            this.remove(t);
        }
        this.add(e);
        return (E)t;
    }
}

