/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.limewire.collection.NodeGenerator;
import org.limewire.collection.Range;
import org.limewire.collection.TreeStorage;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSet
implements Iterable<Range>,
Serializable {
    private static final long serialVersionUID = -7791242963023638684L;
    static final int LINEAR = 16;
    private static final long KB_BOUNDARY = 1023L;
    private final List<Range> intervals = new ArrayList<Range>();

    public static IntervalSet createSingletonSet(long l, long l2) {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(Range.createRange(l, l2));
        return intervalSet;
    }

    public void add(Range range) {
        if (this.intervals.isEmpty()) {
            this.intervals.add(range);
            return;
        }
        long l = range.getLow();
        long l2 = range.getHigh();
        Range range2 = null;
        Range range3 = null;
        int n = this.narrowStart(range)[0];
        Iterator<Range> iterator = this.intervals.subList(n, this.intervals.size()).iterator();
        while (iterator.hasNext()) {
            Range range4 = iterator.next();
            if (l <= range4.getLow() && range4.getHigh() <= l2) {
                iterator.remove();
                continue;
            }
            if (l >= range4.getLow() && range4.getHigh() >= l2) {
                return;
            }
            if (l <= range4.getHigh() + 1L && range4.getLow() < l) {
                range2 = range4;
            }
            if (range4.getLow() - 1L <= l2 && range4.getHigh() > l2) {
                range3 = range4;
            }
            if (range3 == null && range4.getLow() <= l2) continue;
            break;
        }
        if (range2 == null && range3 == null) {
            this.addImpl(Range.createRange(l, l2));
        } else if (range2 != null && range3 != null) {
            this.removeImpl(range3);
            this.removeImpl(range2);
            this.addImpl(Range.createRange(range2.getLow(), range3.getHigh()));
        } else if (range3 != null) {
            this.removeImpl(range3);
            this.addImpl(Range.createRange(l, range3.getHigh()));
        } else {
            assert (range2 != null);
            this.removeImpl(range2);
            this.addImpl(Range.createRange(range2.getLow(), l2));
        }
    }

    public void add(IntervalSet intervalSet) {
        for (Range range : intervalSet) {
            this.add(range);
        }
    }

    public void delete(Range range) {
        long l = range.getLow();
        long l2 = range.getHigh();
        Range range2 = null;
        Range range3 = null;
        int[] nArray = this.narrowRange(range);
        Iterator<Range> iterator = this.intervals.subList(nArray[0], nArray[1]).iterator();
        while (iterator.hasNext()) {
            Range range4 = iterator.next();
            if (range4.getHigh() >= l && range4.getLow() <= l2) {
                iterator.remove();
                if (range4.getHigh() <= l2) {
                    if (range4.getLow() >= l) continue;
                    range2 = Range.createRange(range4.getLow(), l - 1L);
                    continue;
                }
                if (range4.getLow() >= l) {
                    range3 = Range.createRange(l2 + 1L, range4.getHigh());
                    break;
                }
                range2 = Range.createRange(range4.getLow(), l - 1L);
                range3 = Range.createRange(l2 + 1L, range4.getHigh());
                break;
            }
            if (range4.getLow() < l2) continue;
            break;
        }
        if (range2 != null) {
            this.add(range2);
        }
        if (range3 != null) {
            this.add(range3);
        }
    }

    public void delete(IntervalSet intervalSet) {
        for (Range range : intervalSet) {
            this.delete(range);
        }
    }

    public Range getFirst() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.intervals.get(0);
    }

    public Range getLast() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        Range range = this.intervals.get(this.intervals.size() - 1);
        return range;
    }

    public int getNumberOfIntervals() {
        return this.intervals.size();
    }

    public boolean contains(Range range) {
        int[] nArray = this.narrowStart(range);
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            Range range2 = this.intervals.get(i);
            if (range2.getLow() <= range.getLow() && range2.getHigh() >= range.getHigh()) {
                return true;
            }
            if (range2.getLow() > range.getHigh()) break;
        }
        return false;
    }

    private int[] narrowStart(Range range) {
        int n = this.intervals.size();
        if (n < 16) {
            return new int[]{0, n};
        }
        int n2 = Collections.binarySearch(this.intervals, range, IntervalComparator.INSTANCE);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        int n3 = Math.max(0, n2 - 1);
        int n4 = Math.min(n, n2 + 1);
        return new int[]{n3, n4};
    }

    private int[] narrowRange(Range range) {
        int n;
        int n2 = this.intervals.size();
        if (n2 < 16) {
            return new int[]{0, n2};
        }
        int n3 = Collections.binarySearch(this.intervals, range, IntervalComparator.INSTANCE);
        if (n3 < 0) {
            n3 = -(n3 + 1);
        }
        if ((n = Collections.binarySearch(this.intervals, Range.createRange(range.getHigh(), range.getHigh()), IntervalComparator.INSTANCE)) < 0) {
            n = -(n + 1);
        }
        n3 = Math.max(0, n3 - 1);
        n = Math.min(n2, n + 1);
        return new int[]{n3, n};
    }

    public boolean containsAny(Range range) {
        long l = range.getLow();
        long l2 = range.getHigh();
        int[] nArray = this.narrowStart(range);
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            Range range2 = this.intervals.get(i);
            if (l <= range2.getLow() && range2.getHigh() <= l2) {
                return true;
            }
            if (l >= range2.getLow() && range2.getHigh() >= l2) {
                return true;
            }
            if (l <= range2.getHigh() + 1L && range2.getLow() < l) {
                return true;
            }
            if (range2.getLow() - 1L > l2 || range2.getHigh() <= l2) continue;
            return true;
        }
        return false;
    }

    public List<Range> getOverlapIntervals(Range range) {
        ArrayList<Range> arrayList = new ArrayList<Range>();
        long l = range.getHigh();
        long l2 = range.getLow();
        if (l2 > l) {
            return arrayList;
        }
        int[] nArray = this.narrowRange(range);
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            Range range2 = this.intervals.get(i);
            if (l2 <= range2.getLow() && range2.getHigh() <= l) {
                arrayList.add(range2);
                continue;
            }
            if (l2 <= range2.getHigh() && range2.getLow() < l2) {
                arrayList.add(Range.createRange(l2, Math.min(l, range2.getHigh())));
            }
            if (range2.getLow() > l || range2.getHigh() <= l) continue;
            arrayList.add(Range.createRange(Math.max(range2.getLow(), l2), l));
        }
        return arrayList;
    }

    public Iterator<Range> getAllIntervals() {
        return this.intervals.iterator();
    }

    @Override
    public Iterator<Range> iterator() {
        return this.intervals.iterator();
    }

    public List<Range> getAllIntervalsAsList() {
        return new ArrayList<Range>(this.intervals);
    }

    public long getSize() {
        long l = 0L;
        for (Range range : this.intervals) {
            l += range.getHigh() - range.getLow() + 1L;
        }
        return l;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public Collection<Integer> encode(long l) {
        long l2 = IntervalSet.getNumLeafs(l);
        TreeStorage treeStorage = new TreeStorage(null, new NodeGenerator.NullGenerator(), (int)l2);
        treeStorage.setAllowUnverifiedUse(true);
        for (Range range : this.intervals) {
            if ((range = this.align(range, l)) == null) continue;
            for (long i = range.getLow(); i <= range.getHigh(); i += 1024L) {
                int n = treeStorage.fileToNodeId((int)(i >> 10));
                treeStorage.add(n, null);
                treeStorage.used(n);
            }
        }
        return treeStorage.getUsedNodes();
    }

    private Range align(Range range, long l) {
        long l2 = range.getLow();
        long l3 = range.getHigh();
        if (l3 != l - 1L ? l3 - l2 < 1023L : l3 % 1024L > l3 - l2) {
            return null;
        }
        if ((l2 & 0x3FFL) != 0L) {
            l2 = (l2 & 0xFFFFFFFFFFFFFC00L) + 1024L;
        }
        if (l3 != l - 1L && (l3 + 1L & 0x3FFL) != 0L) {
            l3 = (l3 + 1L & 0xFFFFFFFFFFFFFC00L) - 1L;
        }
        if (l2 == range.getLow() && l3 == range.getHigh()) {
            return range;
        }
        if (l3 < l2) {
            return null;
        }
        return Range.createRange(l2, l3);
    }

    public void decode(long l, Integer ... integerArray) {
        long l2 = IntervalSet.getNumLeafs(l);
        TreeStorage treeStorage = new TreeStorage(null, new NodeGenerator.NullGenerator(), (int)l2);
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            int[] nArray = treeStorage.nodeToFileId(n2);
            if (nArray == null) continue;
            Range range = Range.createRange((long)nArray[0] * 1024L, Math.min((long)(nArray[1] + 1) * 1024L - 1L, l - 1L));
            this.add(range);
        }
    }

    private static int getNumLeafs(long l) {
        long l2 = l >> 10;
        if (l % 1024L != 0L) {
            ++l2;
        }
        assert (l2 <= Integer.MAX_VALUE);
        return (int)l2;
    }

    public IntervalSet invert(long l) {
        IntervalSet intervalSet = new IntervalSet();
        if (l < 1L) {
            return intervalSet;
        }
        if (this.intervals.size() == 0) {
            Range range = Range.createRange(0L, l - 1L);
            intervalSet.add(range);
            return intervalSet;
        }
        long l2 = -1L;
        Range range = null;
        boolean bl = false;
        Iterator<Range> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            range = iterator.next();
            if (range.getLow() != 0L && l2 < range.getLow()) {
                if (l2 + 1L > range.getLow() - 1L) {
                    if (!bl) {
                        bl = true;
                        this.fix();
                        iterator = this.intervals.iterator();
                        l2 = -1L;
                        range = null;
                        continue;
                    }
                    throw new IllegalArgumentException("constructing invalid interval  while trying to invert \n" + this.toString() + " \n with size " + l + " low:" + l2 + " interval.low:" + range.getLow());
                }
                intervalSet.add(Range.createRange(l2 + 1L, range.getLow() - 1L));
            }
            l2 = range.getHigh();
        }
        assert (range != null) : "Null interval in getFreeBlocks";
        if (range.getHigh() < l - 1L) {
            intervalSet.add(Range.createRange(range.getHigh() + 1L, l - 1L));
        }
        return intervalSet;
    }

    public Iterator<Range> getNeededIntervals(long l) {
        return this.invert(l).getAllIntervals();
    }

    public IntervalSet clone() {
        IntervalSet intervalSet = new IntervalSet();
        for (Range range : this) {
            intervalSet.intervals.add(range);
        }
        return intervalSet;
    }

    private void addImpl(Range range) {
        int n = Collections.binarySearch(this.intervals, range, IntervalComparator.INSTANCE);
        if (n >= 0) {
            throw new IllegalStateException("interval (" + range + ") already in list: " + this.intervals);
        }
        n = -(n + 1);
        this.intervals.add(n, range);
    }

    private void removeImpl(Range range) {
        int n = Collections.binarySearch(this.intervals, range, IntervalComparator.INSTANCE);
        if (n < 0) {
            throw new IllegalStateException("interval (" + range + ") doesn't exist in list: " + this.intervals);
        }
        this.intervals.remove(n);
    }

    public String toString() {
        return this.intervals.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntervalSet) {
            IntervalSet intervalSet = (IntervalSet)object;
            if (this.intervals.size() == intervalSet.intervals.size()) {
                for (int i = 0; i < this.intervals.size(); ++i) {
                    if (this.intervals.get(i).equals(intervalSet.intervals.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public ByteIntervals toBytes() {
        int n = 0;
        for (Range object2 : this.intervals) {
            n += object2.isLong() ? 1 : 0;
        }
        Object object3 = new byte[(this.intervals.size() - n) * 8];
        byte[] byArray = new byte[n * 10];
        int n2 = 0;
        int n3 = 0;
        for (Range range : this.intervals) {
            if (range.isLong()) {
                range.toBytes(byArray, n3);
                n3 += 10;
                continue;
            }
            range.toBytes((byte[])object3, n2);
            n2 += 8;
        }
        return new ByteIntervals((byte[])object3, byArray);
    }

    public static IntervalSet parseBytes(byte[] byArray, byte[] byArray2) throws IOException {
        int n;
        if (byArray.length % 8 != 0 || byArray2.length % 10 != 0) {
            throw new IOException();
        }
        IntervalSet intervalSet = new IntervalSet();
        for (n = 0; n < byArray.length / 8; ++n) {
            int n2 = (int)ByteOrder.uint2long((int)ByteOrder.beb2int((byte[])byArray, (int)(n * 8)));
            int n3 = (int)ByteOrder.uint2long((int)ByteOrder.beb2int((byte[])byArray, (int)(n * 8 + 4)));
            if (n3 < n2 || n2 < 0) {
                throw new IOException();
            }
            intervalSet.add(Range.createRange(n2, n3));
        }
        for (n = 0; n < byArray2.length / 10; ++n) {
            long l = ByteOrder.beb2long((byte[])byArray2, (int)(n * 10), (int)5);
            long l2 = ByteOrder.beb2long((byte[])byArray2, (int)(n * 10 + 5), (int)5);
            if (l2 < l || l < 0L) {
                throw new IOException();
            }
            intervalSet.add(Range.createRange(l, l2));
        }
        return intervalSet;
    }

    private void fix() {
        String string = this.intervals.toString();
        ArrayList<Range> arrayList = new ArrayList<Range>(this.intervals);
        this.intervals.clear();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            this.add((Range)object.next());
        }
        object = this.intervals.toString();
        ErrorService.error((Throwable)new IllegalStateException("IntervalSet invariants broken.\nPre  Fixing: " + string + "\n" + "Post Fixing: " + (String)object));
    }

    public static class ByteIntervals {
        public final byte[] ints;
        public final byte[] longs;

        private ByteIntervals(byte[] byArray, byte[] byArray2) {
            this.ints = byArray;
            this.longs = byArray2;
        }

        public int length() {
            return this.ints.length + this.longs.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntervalComparator
    implements Comparator<Range> {
        private static final IntervalComparator INSTANCE = new IntervalComparator();

        private IntervalComparator() {
        }

        @Override
        public int compare(Range range, Range range2) {
            if (range.getLow() > range2.getLow()) {
                return 1;
            }
            if (range.getLow() < range2.getLow()) {
                return -1;
            }
            return 0;
        }
    }
}

