/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.NodeGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeStorage {
    private static final TreeNode PADDING = new TreeNode();
    private final TreeNodeMap map = new TreeNodeMap(false);
    private final NodeGenerator generator;
    private final int maxId;
    private boolean allowUnverifiedUse;

    TreeStorage(byte[] byArray, NodeGenerator nodeGenerator, int n) {
        this.generator = nodeGenerator;
        this.maxId = (1 << TreeStorage.log2Ceil(n)) + n - 1;
        assert (this.maxId == this.fileToNodeId(n - 1)) : "max Id: " + this.maxId + " vs " + this.fileToNodeId(n - 1);
        TreeNode treeNode = new TreeNode(1, byArray);
        treeNode.verified = true;
        this.map.put(1, treeNode);
    }

    public void setAllowUnverifiedUse(boolean bl) {
        this.allowUnverifiedUse = bl;
    }

    public boolean add(int n, byte[] byArray) {
        assert (n > 0 && n <= this.maxId) : "bad id " + n;
        TreeNode treeNode = this.map.get(n);
        if (treeNode != null && treeNode.verified) {
            return false;
        }
        TreeNode treeNode2 = new TreeNode(n, byArray);
        this.verify(treeNode2);
        this.map.put(n, treeNode2);
        return treeNode2.verified;
    }

    public byte[] get(int n) {
        TreeNode treeNode = this.map.get(n);
        if (treeNode != null && treeNode.verified) {
            return treeNode.data;
        }
        return null;
    }

    public void used(int n) {
        TreeNode treeNode = this.map.get(n);
        assert (treeNode != null);
        assert (this.allowUnverifiedUse || treeNode.verified);
        treeNode.used = true;
        this.consolidate(treeNode);
    }

    public Collection<Integer> getUsedNodes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.map.size());
        for (int n : this.map) {
            if (!this.map.get(n).used) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    public Collection<Integer> getVerifiedNodes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.map.size());
        for (int n : this.map) {
            if (!this.map.get(n).verified) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    private void consolidate(TreeNode treeNode) {
        TreeNode treeNode2;
        TreeNode[] treeNodeArray = this.getSiblings(treeNode);
        if (treeNodeArray[0] == null || treeNodeArray[1] == null) {
            return;
        }
        if (!treeNodeArray[0].used || !treeNodeArray[1].used) {
            return;
        }
        TreeNode treeNode3 = this.map.get(treeNode.id / 2);
        if (treeNode3 != null) {
            assert (this.allowUnverifiedUse || treeNode3.verified);
            assert (!treeNode3.used);
            treeNode2 = treeNode3;
        } else {
            treeNode2 = this.generateParent(treeNodeArray);
        }
        treeNode2.verified = true;
        treeNode2.used = true;
        this.map.remove(treeNodeArray[0].id);
        this.map.remove(treeNodeArray[1].id);
        this.map.put(treeNode2.id, treeNode2);
        this.consolidate(treeNode2);
    }

    private TreeNode[] getSiblings(TreeNode treeNode) {
        TreeNode[] treeNodeArray = new TreeNode[2];
        if (treeNode.id % 2 == 0) {
            treeNodeArray[0] = treeNode;
            treeNodeArray[1] = treeNode.id == this.maxId ? PADDING : this.map.get(treeNode.id + 1);
        } else {
            treeNodeArray[0] = this.map.get(treeNode.id - 1);
            treeNodeArray[1] = treeNode;
        }
        return treeNodeArray;
    }

    private void verify(TreeNode treeNode) {
        boolean bl;
        TreeNode[] treeNodeArray = this.getSiblings(treeNode);
        if (treeNodeArray[0] == null || treeNodeArray[1] == null) {
            return;
        }
        assert (!(!this.allowUnverifiedUse && treeNodeArray[0].verified || treeNodeArray[1].verified && treeNodeArray[1] != PADDING));
        TreeNode treeNode2 = this.generateParent(treeNodeArray);
        TreeNode treeNode3 = this.map.get(treeNode2.id);
        boolean bl2 = bl = treeNode3 != null && Arrays.equals(treeNode3.data, treeNode2.data);
        if (bl) {
            treeNode2 = treeNode3;
        }
        if (!treeNode2.verified) {
            this.verify(treeNode2);
        }
        if (treeNode2.verified) {
            this.markVerified(treeNodeArray[0]);
            this.markVerified(treeNodeArray[1]);
            if (treeNode2.id != 1) {
                this.map.remove(treeNode2.id);
            }
        } else if (treeNode2.id != 1) {
            this.map.put(treeNode2.id, treeNode2);
        }
    }

    private void markVerified(TreeNode treeNode) {
        if (treeNode == null || treeNode == PADDING || treeNode.id == 1) {
            return;
        }
        this.map.remove(treeNode.id);
        treeNode.verified = true;
        this.map.put(treeNode.id, treeNode);
        TreeNode treeNode2 = this.map.get(treeNode.id * 2);
        TreeNode treeNode3 = this.map.get(treeNode.id * 2 + 1);
        if (treeNode2 != null && treeNode3 != null) {
            this.map.remove(treeNode.id);
        }
        this.markVerified(treeNode2);
        this.markVerified(treeNode3);
    }

    private TreeNode generateParent(TreeNode[] treeNodeArray) {
        byte[] byArray = treeNodeArray[1] == PADDING ? treeNodeArray[0].data : this.generator.generate(treeNodeArray[0].data, treeNodeArray[1].data);
        return new TreeNode(treeNodeArray[0].id / 2, byArray);
    }

    public static int log2Ceil(long l) {
        int n = 0;
        while (l > 1L) {
            ++l;
            l >>>= 1;
            ++n;
        }
        return n;
    }

    public int fileToNodeId(int n) {
        int n2 = TreeStorage.log2Ceil(this.maxId);
        int n3 = (1 << Math.max(0, n2 - 1)) + n;
        if (n3 > this.maxId) {
            throw new IllegalArgumentException("fileId " + n + " maxId " + this.maxId + " ret " + n3);
        }
        return n3;
    }

    public int[] nodeToFileId(int n) {
        if (n < 1 || n > this.maxId) {
            return null;
        }
        int n2 = Math.max(1, 1 << TreeStorage.log2Ceil(this.maxId) - 1);
        if (n == 1) {
            return new int[]{0, this.maxId - n2};
        }
        int[] nArray = new int[2];
        int n3 = 0;
        while (n < n2) {
            ++n3;
            n <<= 1;
        }
        if (n > this.maxId) {
            return null;
        }
        nArray[0] = n - n2;
        nArray[1] = Math.min(this.maxId - n2, nArray[0] + (1 << n3) - 1);
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeNodeMap
    implements Iterable<Integer> {
        private final Map<Integer, TreeNode> hardMap = new TreeMap<Integer, TreeNode>();
        private final Map<Integer, SoftReference<TreeNode>> softMap = new TreeMap<Integer, SoftReference<TreeNode>>();
        private final boolean soft;

        TreeNodeMap(boolean bl) {
            this.soft = bl;
        }

        public TreeNode get(int n) {
            TreeNode treeNode = this.hardMap.get(n);
            if (treeNode != null || !this.soft) {
                return treeNode;
            }
            SoftReference<TreeNode> softReference = this.softMap.get(n);
            if (softReference == null) {
                return null;
            }
            return softReference.get();
        }

        public TreeNode put(int n, TreeNode treeNode) {
            if (this.soft) {
                this.softMap.remove(n);
            }
            return this.hardMap.put(n, treeNode);
        }

        public TreeNode remove(int n) {
            TreeNode treeNode = this.hardMap.remove(n);
            if (treeNode != null && this.soft) {
                this.softMap.put(n, new SoftReference<TreeNode>(treeNode));
            }
            return treeNode;
        }

        public int size() {
            return this.hardMap.size();
        }

        @Override
        public Iterator<Integer> iterator() {
            if (this.soft) {
                return new CachingIterator();
            }
            return this.hardMap.keySet().iterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CachingIterator
        implements Iterator<Integer> {
            private final Iterator<Integer> hardIterator;
            private int currentId;
            private TreeNode currentNode;

            private CachingIterator() {
                this.hardIterator = TreeNodeMap.this.hardMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.hardIterator.hasNext();
            }

            @Override
            public Integer next() {
                this.currentId = this.hardIterator.next();
                this.currentNode = (TreeNode)TreeNodeMap.this.hardMap.get(this.currentId);
                return this.currentId;
            }

            @Override
            public void remove() {
                if (this.currentId <= 0) {
                    throw new IllegalStateException();
                }
                this.hardIterator.remove();
                TreeNodeMap.this.softMap.put(this.currentId, new SoftReference<TreeNode>(this.currentNode));
                this.currentId = 0;
                this.currentNode = null;
            }
        }
    }

    private static class TreeNode {
        private final int id;
        private final byte[] data;
        private boolean used;
        private boolean verified;

        TreeNode() {
            this.id = Integer.MAX_VALUE;
            this.data = null;
            this.used = true;
            this.verified = true;
        }

        TreeNode(int n, byte[] byArray) {
            this.id = n;
            this.data = byArray;
        }

        public String toString() {
            return "id " + this.id + " verified " + this.verified + " used " + this.used;
        }
    }
}

