/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.limewire.net.ProxyManager;
import org.limewire.net.SimpleSocketController;
import org.limewire.net.SocketBindingSettings;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;

@Singleton
class LimitedSocketController
extends SimpleSocketController {
    private static final int DEFAULT_MAX_CONNECTING_SOCKETS = 4;
    private final int MAX_CONNECTING_SOCKETS;
    private int _socketsConnecting = 0;
    private final List<Requestor> WAITING_REQUESTS = new LinkedList<Requestor>();

    @Inject
    LimitedSocketController(ProxyManager proxyManager, SocketBindingSettings socketBindingSettings) {
        this(proxyManager, socketBindingSettings, 4);
    }

    LimitedSocketController(ProxyManager proxyManager, SocketBindingSettings socketBindingSettings, int n) {
        super(proxyManager, socketBindingSettings);
        this.MAX_CONNECTING_SOCKETS = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket connectPlain(NBSocket nBSocket, InetSocketAddress inetSocketAddress, NBSocketFactory nBSocketFactory, InetSocketAddress inetSocketAddress2, int n, ConnectObserver connectObserver) throws IOException {
        if (nBSocket == null) {
            nBSocket = nBSocketFactory.createSocket();
        }
        this.bindSocket(nBSocket, inetSocketAddress);
        if (connectObserver == null) {
            this.waitForSocket();
            try {
                nBSocket.connect((SocketAddress)inetSocketAddress2, n);
            }
            finally {
                this.releaseSocket();
            }
        } else if (this.addWaitingSocket(nBSocket, inetSocketAddress2, n, connectObserver)) {
            nBSocket.connect((SocketAddress)inetSocketAddress2, n, (ConnectObserver)new DelegateConnector(connectObserver));
        }
        return nBSocket;
    }

    public synchronized boolean removeConnectObserver(ConnectObserver connectObserver) {
        Iterator<Requestor> iterator = this.WAITING_REQUESTS.iterator();
        while (iterator.hasNext()) {
            Requestor requestor = iterator.next();
            if (requestor.observer == connectObserver) {
                iterator.remove();
                return true;
            }
            if (!(requestor.observer instanceof ProxyManager.ProxyConnector) || ((ProxyManager.ProxyConnector)requestor.observer).getDelegateObserver() != connectObserver) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getNumAllowedSockets() {
        return this.MAX_CONNECTING_SOCKETS;
    }

    public synchronized int getNumWaitingSockets() {
        return this.WAITING_REQUESTS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWaitingRequests() {
        Requestor requestor;
        ArrayList<Requestor> arrayList = new ArrayList<Requestor>(Math.min(this.WAITING_REQUESTS.size(), Math.max(0, this.MAX_CONNECTING_SOCKETS - this._socketsConnecting)));
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            while (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS && !this.WAITING_REQUESTS.isEmpty()) {
                requestor = this.WAITING_REQUESTS.remove(0);
                if (requestor.socket.isClosed()) continue;
                arrayList.add(requestor);
                ++this._socketsConnecting;
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            requestor = (Requestor)arrayList.get(i);
            requestor.socket.setShutdownObserver(null);
            requestor.socket.connect((SocketAddress)requestor.addr, requestor.timeout, (ConnectObserver)new DelegateConnector(requestor.observer));
        }
    }

    private synchronized boolean addWaitingSocket(NBSocket nBSocket, InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) {
        if (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            this.WAITING_REQUESTS.add(new Requestor(nBSocket, inetSocketAddress, n, connectObserver));
            nBSocket.setShutdownObserver((Shutdownable)new RemovalObserver(connectObserver));
            return false;
        }
        ++this._socketsConnecting;
        return true;
    }

    private synchronized void waitForSocket() throws IOException {
        while (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.getMessage());
            }
        }
        ++this._socketsConnecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSocket() {
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            --this._socketsConnecting;
        }
        this.runWaitingRequests();
        limitedSocketController = this;
        synchronized (limitedSocketController) {
            if (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS) {
                this.notifyAll();
            }
        }
    }

    private static class Requestor {
        private final InetSocketAddress addr;
        private final int timeout;
        private final NBSocket socket;
        private final ConnectObserver observer;

        Requestor(NBSocket nBSocket, InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) {
            this.socket = nBSocket;
            this.addr = inetSocketAddress;
            this.timeout = n;
            this.observer = connectObserver;
        }
    }

    private class DelegateConnector
    implements ConnectObserver {
        private final ConnectObserver delegate;

        DelegateConnector(ConnectObserver connectObserver) {
            this.delegate = connectObserver;
        }

        public void handleConnect(Socket socket) throws IOException {
            LimitedSocketController.this.releaseSocket();
            this.delegate.handleConnect(socket);
        }

        public void shutdown() {
            LimitedSocketController.this.releaseSocket();
            this.delegate.shutdown();
        }

        public void handleIOException(IOException iOException) {
        }
    }

    private class RemovalObserver
    implements Shutdownable {
        private final ConnectObserver delegate;

        RemovalObserver(ConnectObserver connectObserver) {
            this.delegate = connectObserver;
        }

        public void shutdown() {
            if (LimitedSocketController.this.removeConnectObserver(this.delegate)) {
                this.delegate.shutdown();
            }
        }
    }
}

