/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.AsyncConnectionDispatcher;
import org.limewire.net.BlockingConnectionDispatcher;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.SocketFactory;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.AcceptObserver;

public class SocketAcceptor {
    private final ConnectionDispatcher dispatcher;
    private ServerSocket listeningSocket = null;
    private volatile int listeningPort = -1;
    private volatile boolean localOnly;

    public SocketAcceptor(ConnectionDispatcher connectionDispatcher) {
        this.dispatcher = connectionDispatcher;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setLocalOnly(boolean bl) {
        this.localOnly = bl;
    }

    public synchronized void bind(int n) throws IOException {
        if (this.listeningSocket != null && this.listeningPort == n) {
            return;
        }
        ServerSocket serverSocket = SocketFactory.newServerSocket((int)n, (AcceptObserver)new SocketListener());
        if (this.listeningSocket != null) {
            IOUtils.close((ServerSocket)this.listeningSocket);
        }
        this.listeningSocket = serverSocket;
        this.listeningPort = n;
    }

    public synchronized void unbind() {
        if (this.listeningSocket == null) {
            return;
        }
        IOUtils.close((ServerSocket)this.listeningSocket);
        this.listeningSocket = null;
        this.listeningPort = -1;
    }

    public int getPort() {
        return this.listeningPort;
    }

    public ConnectionDispatcher getDispatcher() {
        return this.dispatcher;
    }

    private class SocketListener
    implements AcceptObserver {
        private SocketListener() {
        }

        public void handleIOException(IOException iOException) {
        }

        public void shutdown() {
        }

        public void handleAccept(Socket socket) {
            if (SocketAcceptor.this.isLocalOnly() && !NetworkUtils.isLocalHost((Socket)socket)) {
                IOUtils.close((Socket)socket);
                return;
            }
            if (socket instanceof NIOMultiplexor) {
                ((NIOMultiplexor)socket).setReadObserver((ChannelReadObserver)new AsyncConnectionDispatcher(SocketAcceptor.this.dispatcher, socket, null));
            } else {
                ThreadExecutor.startThread((Runnable)new BlockingConnectionDispatcher(SocketAcceptor.this.dispatcher, socket, null), (String)"BlockingConnectionDispatchRunner");
            }
        }
    }
}

