/* config.vapi
 *
 * Copyright (C) 2009-2010  troorl
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	troorl <troorl@gmail.com>
 */

[CCode (cprefix = "", lower_case_cprefix = "", cheader_filename = "config.h")]
namespace Config
{
	public const string GETTEXT_PACKAGE;
	public const string APPNAME;
	public const string APP_PATH;
	public const string LOCALE_DIR;
	public const string APP_VERSION;
	public const string DESKTOP_FILE_PATH;
	public const string LOGO_PATH;
	public const string LOGO_FRESH_PATH;
	public const string MENTIONS_PATH;
	public const string MENTIONS_FRESH_PATH;
	public const string TIMELINE_PATH;
	public const string TIMELINE_FRESH_PATH;
	public const string DIRECT_PATH;
	public const string DIRECT_FRESH_PATH;
	public const string FAVORITE_PATH;
	public const string FAVORITE_NO_PATH;
	//public const string FAVORITE_MENU_PATH;
	public const string PROGRESS_PATH;
	public const string DIRECT_REPLY_PATH;
	public const string REPLY_PATH;
	public const string RETWEET_PATH;
	public const string DELETE_PATH;
	public const string USERPIC_PATH;
	public const string TEMPLATES_PATH;
	public const string AUTHORS;
	
	public const string CONS_KEY;
	public const string CONS_SEC;
}

namespace Gtk
{
  [CCode (cprefix = "GTKSPELL_ERROR_", cheader_filename = "gtkspell/gtkspell.h")]
  public errordomain SpeelError
  {
    ERROR_BACKEND
  }

  [Compact]
  [CCode (cheader_filename = "gtkspell/gtkspell.h", free_function = "")]
  public class Spell
  {
    [CCode (cname = "gtkspell_new_attach")]
    public Spell.attach (TextView view, string? lang) throws GLib.Error;
    [CCode (cname = "gtkspell_get_from_text_view")]
    public static Spell get_from_text_view (TextView view);
    [CCode (cname = "gtkspell_detach")]
    public void detach ();
    [CCode (cname = "gtkspell_set_language")]
    public bool set_language (string lang) throws GLib.Error;
    [CCode (cname = "gtkspell_recheck_all")]
    public void recheck_all ();
  }
}

[CCode (cheader_filename = "time_parser.h")]
namespace TimeParser {
	[CCode (cname = "time_to_diff")]
	public int time_to_diff(string datetime);
}

/* indicate.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Indicate", lower_case_cprefix = "indicate_")]
namespace Indicate {
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public class Indicator : GLib.Object {
		[CCode (has_construct_function = false)]
		public Indicator ();
		public bool get_displayed ();
		public uint get_id ();
		public virtual unowned string get_property (string key);
		public void hide ();
		[NoWrapper]
		public virtual void indicate_indicator_reserved1 ();
		[NoWrapper]
		public virtual void indicate_indicator_reserved2 ();
		[NoWrapper]
		public virtual void indicate_indicator_reserved3 ();
		[NoWrapper]
		public virtual void indicate_indicator_reserved4 ();
		public bool is_visible ();
		public virtual unowned GLib.PtrArray list_properties ();
		public void set_displayed (bool displayed);
		public virtual void set_property (string key, string data);
		public void set_property_bool (string key, bool value);
		public void set_property_icon(string key, Gdk.Pixbuf data); /* indicate-gtk method */
		public void set_property_int (string key, int value);
		public void set_property_time (string key, GLib.TimeVal time);
		public void set_server (Indicate.Server server);
		public void show ();
		public signal void user_display ();
		[CCode (has_construct_function = false)]
		public Indicator.with_server (Indicate.Server server);
		[CCode (name = "displayed")]
		public virtual signal void sig_displayed (bool displayed);
		[CCode (name = "hide")]
		public virtual signal void sig_hide ();
		[CCode (name = "modified")]
		public virtual signal void sig_modified (string property);
		[CCode (name = "show")]
		public virtual signal void sig_show ();
		[CCode (name = "user_display")]
		public virtual signal void sig_user_display ();
	}
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public class Listener : GLib.Object {
		[CCode (has_construct_function = false)]
		public Listener ();
		public void display (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator);
		public void displayed (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, bool displayed);
		public void get_property (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_cb callback, void* data);
		public void get_property_bool (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_bool_cb callback, void* data);
		public void get_property_int (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_int_cb callback, void* data);
		public void get_property_time (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_time_cb callback, void* data);
		[NoWrapper]
		public virtual void indicate_listener_reserved1 ();
		[NoWrapper]
		public virtual void indicate_listener_reserved2 ();
		[NoWrapper]
		public virtual void indicate_listener_reserved3 ();
		[NoWrapper]
		public virtual void indicate_listener_reserved4 ();
		public static unowned Indicate.Listener ref_default ();
		public void set_default_max_indicators (int max);
		public void set_server_max_indicators (Indicate.ListenerServer server, int max);
		public virtual signal void indicator_added (Indicate.ListenerServer indicator, Indicate.ListenerIndicator p1);
		public virtual signal void indicator_modified (Indicate.ListenerServer indicator, Indicate.ListenerIndicator property, string p2);
		public virtual signal void indicator_removed (Indicate.ListenerServer indicator, Indicate.ListenerIndicator p1);
		public virtual signal void server_added (Indicate.ListenerServer type, string p1);
		public virtual signal void server_count_changed (Indicate.ListenerServer count, uint p1);
		public virtual signal void server_removed (Indicate.ListenerServer type, string p1);
	}
	[Compact]
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public class ListenerIndicator {
		public static GLib.Type get_gtype ();
		public uint get_id ();
	}
	[Compact]
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public class ListenerServer {
		public static bool check_interest (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.Interests interest);
		public static void get_count (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.indicate_listener_get_server_uint_property_cb callback, void* data);
		public unowned string get_dbusname ();
		public static void get_desktop (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.indicate_listener_get_server_property_cb callback, void* data);
		public static GLib.Type get_gtype ();
		public static void remove_interest (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.Interests interest);
		public static void show_interest (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.Interests interest);
	}
	[CCode (cheader_filename = "libindicate/server.h")]
	public class Server : GLib.Object {
		public void add_indicator (Indicate.Indicator indicator);
		public virtual bool check_interest (Indicate.Interests interest);
		[NoWrapper]
		public virtual bool get_indicator_count (out uint count) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_list (out unowned GLib.Array indicators) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_properties (uint id, string properties) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_property (uint id, string property, string value) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_property_group (uint id, GLib.PtrArray properties, string value) throws GLib.Error;
		public int get_max_indicators ();
		public virtual uint get_next_id ();
		public void hide ();
		[NoWrapper]
		public virtual void indicate_server_reserved1 ();
		[NoWrapper]
		public virtual void indicate_server_reserved2 ();
		[NoWrapper]
		public virtual void indicate_server_reserved3 ();
		[NoWrapper]
		public virtual void indicate_server_reserved4 ();
		[NoWrapper]
		public virtual void indicator_added (uint id);
		[NoWrapper]
		public virtual bool indicator_displayed (string sender, uint id, bool displayed) throws GLib.Error;
		[NoWrapper]
		public virtual void indicator_removed (uint id);
		[NoWrapper]
		public virtual int max_indicators_get ();
		[NoWrapper]
		public virtual bool max_indicators_set (string sender, int max);
		public static unowned Indicate.Server ref_default ();
		public void remove_indicator (Indicate.Indicator indicator);
		[NoWrapper]
		public virtual bool remove_interest (string sender, Indicate.Interests interest);
		public void set_count (uint count);
		public static void set_dbus_object (string obj);
		public void set_default ();
		public void set_desktop_file (string path);
		public void set_type (string type);
		public void show ();
		[NoWrapper]
		public virtual bool show_indicator_to_user (uint id) throws GLib.Error;
		[NoWrapper]
		public virtual bool show_interest (string sender, Indicate.Interests interest);
		[NoAccessorMethod]
		public uint count { get; set; }
		[NoAccessorMethod]
		public string desktop { owned get; set; }
		[NoAccessorMethod]
		public string type { owned get; set; }
		public virtual signal void indicator_delete (uint p0);
		public virtual signal void indicator_modified (uint id, string property);
		public virtual signal void indicator_new (uint p0);
		public virtual signal void interest_added (uint interest);
		public virtual signal void interest_removed (uint interest);
		public virtual signal void max_indicators_changed (int max);
		public virtual signal void server_count_changed (uint count);
		public virtual signal void server_display ();
		public virtual signal void server_hide (string type);
		public virtual signal void server_show (string type);
	}
	[CCode (cprefix = "INDICATE_INTEREST_", cheader_filename = "libindicate/interests.h")]
	public enum Interests {
		NONE,
		SERVER_DISPLAY,
		SERVER_SIGNAL,
		INDICATOR_DISPLAY,
		INDICATOR_SIGNAL,
		INDICATOR_COUNT,
		LAST
	}
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public delegate void indicate_listener_get_property_bool_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, bool propertydata);
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public delegate void indicate_listener_get_property_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, string propertydata);
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public delegate void indicate_listener_get_property_int_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, int propertydata);
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public delegate void indicate_listener_get_property_time_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, GLib.TimeVal propertydata);
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public delegate void indicate_listener_get_server_property_cb (Indicate.Listener listener, Indicate.ListenerServer server, string value);
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public delegate void indicate_listener_get_server_uint_property_cb (Indicate.Listener listener, Indicate.ListenerServer server, uint value);
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const int INDICATOR_H_INCLUDED__;
	[CCode (cheader_filename = "libindicate/indicator-messages.h")]
	public const int INDICATOR_MESSAGES_H_INCLUDED__;
	[CCode (cheader_filename = "libindicate/indicator-messages.h")]
	public const string INDICATOR_MESSAGES_PROP_ATTENTION;
	[CCode (cheader_filename = "libindicate/indicator-messages.h")]
	public const string INDICATOR_MESSAGES_PROP_COUNT;
	[CCode (cheader_filename = "libindicate/indicator-messages.h")]
	public const string INDICATOR_MESSAGES_PROP_ICON;
	[CCode (cheader_filename = "libindicate/indicator-messages.h")]
	public const string INDICATOR_MESSAGES_PROP_NAME;
	[CCode (cheader_filename = "libindicate/indicator-messages.h")]
	public const string INDICATOR_MESSAGES_PROP_TIME;
	[CCode (cheader_filename = "libindicate/indicator-messages.h")]
	public const string INDICATOR_MESSAGES_SERVER_TYPE;
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const string INDICATOR_SIGNAL_DISPLAY;
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const string INDICATOR_SIGNAL_DISPLAYED;
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const string INDICATOR_SIGNAL_HIDE;
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const string INDICATOR_SIGNAL_MODIFIED;
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const string INDICATOR_SIGNAL_SHOW;
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const string INDICATOR_VALUE_FALSE;
	[CCode (cheader_filename = "libindicate-gtk/indicator.h")]
	public const string INDICATOR_VALUE_TRUE;
	[CCode (cheader_filename = "libindicate/interests.h")]
	public const int INTERESTS_H_INCLUDED__;
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public const int LISTENER_H_INCLUDED__;
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public const string LISTENER_SIGNAL_INDICATOR_ADDED;
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public const string LISTENER_SIGNAL_INDICATOR_MODIFIED;
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public const string LISTENER_SIGNAL_INDICATOR_REMOVED;
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public const string LISTENER_SIGNAL_SERVER_ADDED;
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public const string LISTENER_SIGNAL_SERVER_COUNT_CHANGED;
	[CCode (cheader_filename = "libindicate-gtk/listener.h")]
	public const string LISTENER_SIGNAL_SERVER_REMOVED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const int SERVER_H_INCLUDED__;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const int SERVER_INDICATOR_NULL;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_INDICATOR_ADDED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_INDICATOR_MODIFIED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_INDICATOR_REMOVED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_INTEREST_ADDED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_INTEREST_REMOVED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_MAX_INDICATORS_CHANGED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_SERVER_COUNT_CHANGED;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_SERVER_DISPLAY;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_SERVER_HIDE;
	[CCode (cheader_filename = "libindicate/server.h")]
	public const string SERVER_SIGNAL_SERVER_SHOW;
}

/*
[CCode (cheader_filename = "sha1.h")]
namespace SHA1
{
  [CCode (cname = "_oauth_hmac_sha1")]
  public void hmac (string key, string message, out uchar[] output);
}
*/
