# Copyright 2009 Steven Robertson
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

import gtk

from quodlibet import config

class ConfigListItem(ConfigString):
    def __init__(self, section, option, choices, default = None):
        self.choices = choices
        super(self, ConfigString).__init__(section, option, default)

    def _validate(self, value):
        value = super(self, ConfigString)._validate(value)
        if value not in self.choices:
            raise ValueError('Value "%s" not in list of choices' % value)


# Copyright 2005 Joe Wreschnig, Michael Urman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation

import gtk

from quodlibet import config

class ConfigCheckButton(gtk.CheckButton):
    """A CheckButton that connects to QL's config module, and toggles
    a boolean configuration value when it is toggled.

    It is *not* set to the current config value initially."""

    def __init__(self, label, section, option):
        super(ConfigCheckButton, self).__init__(label)
        self.connect('toggled', ConfigCheckButton.__toggled, section, option)

    def __toggled(self, section, option):
        config.set(section, option, str(bool(self.get_active())).lower())

class ConfigCheckMenuItem(gtk.CheckMenuItem):
    """A CheckMenuItem that connects to QL's config module, and toggles
    a boolean configuration value when it is toggled.

    It is *not* set to the current config value initially."""

    def __init__(self, label, section, option):
        super(ConfigCheckMenuItem, self).__init__(label)
        self.connect('toggled', ConfigCheckMenuItem.__toggled, section, option)

    def __toggled(self, section, option):
        config.set(section, option, str(bool(self.get_active())).lower())

    

class ConfigCheckButton(gtk.CheckButton)
