/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.CreateUserDialog;
import com.pugh.sockso.gui.MyTableModel;
import com.pugh.sockso.gui.controls.BooleanOptionField;
import com.pugh.sockso.resources.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class UsersPanel
extends JPanel {
    private static Logger log = Logger.getLogger(UsersPanel.class);
    private Properties p;
    private Database db;
    private Resources r;
    private JFrame parent;
    private MyTableModel model;
    private JTable table;

    public UsersPanel(JFrame parent, Database db, Properties p, Resources r) {
        this.parent = parent;
        this.db = db;
        this.p = p;
        this.r = r;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getOptionsPane(), "North");
        this.add((Component)this.getAccountsPane(), "Center");
        int sixtySeconds = 60000;
        new Thread(){

            public void run() {
                while (true) {
                    UsersPanel.this.refreshUsers();
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    private JPanel getOptionsPane() {
        FormLayout layout = new FormLayout(" right:max(60dlu;pref), 10dlu, 150dlu, 7dlu ");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Options");
        builder.append("Require login:", (Component)new BooleanOptionField(this.p, "users.requireLogin"));
        builder.nextLine();
        builder.append("Disable registering:", (Component)new BooleanOptionField(this.p, "users.disableRegistration"));
        builder.nextLine();
        return builder.getPanel();
    }

    private JPanel getAccountsPane() {
        JButton delete = new JButton("Delete", new ImageIcon(this.r.getImage("icons/16x16/delete.png")));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsersPanel.this.deleteSelectedUser();
            }
        });
        JButton create = new JButton("Create User", new ImageIcon(this.r.getImage("icons/16x16/add.png")));
        create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new CreateUserDialog(UsersPanel.this.parent, UsersPanel.this.db, UsersPanel.this.r, UsersPanel.this);
            }
        });
        JPanel accBtns = new JPanel(new FlowLayout(0));
        accBtns.add(create);
        accBtns.add(delete);
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        TableColumnModel columns = this.table.getColumnModel();
        this.table.getSelectionModel().setSelectionMode(0);
        int[] widths = new int[]{20, 150, 200, 100};
        for (int i = 0; i < widths.length; ++i) {
            columns.getColumn(i).setPreferredWidth(widths[i]);
        }
        JPanel pn = new JPanel();
        pn.setLayout(new BorderLayout());
        pn.add((Component)new JScrollPane(this.table), "Center");
        pn.add((Component)accBtns, "South");
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedUser() {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            PreparedStatement st = null;
            try {
                int id = Integer.parseInt((String)this.model.getValueAt(row, 0));
                String sql = " delete from playlist_tracks  where playlist_id in (  select id  from playlists  where user_id = ?  ) ";
                st = this.db.prepare(sql);
                st.setInt(1, id);
                st.execute();
                st.close();
                sql = " delete from playlists  where user_id = ? ";
                st = this.db.prepare(sql);
                st.setInt(1, id);
                st.execute();
                st.close();
                sql = " delete from users  where id = ? ";
                st = this.db.prepare(sql);
                st.setInt(1, id);
                st.execute();
                st.close();
                this.refreshUsers();
                Utils.close(st);
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
            finally {
                Utils.close(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshUsers() {
        for (int i = this.model.getRowCount(); i > 0; --i) {
            this.model.removeRow(i - 1);
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " select u.id, u.name, u.email, u.date_created  from users u  order by u.name asc ";
            st = this.db.prepare(" select u.id, u.name, u.email, u.date_created  from users u  order by u.name asc ");
            rs = st.executeQuery();
            while (rs.next()) {
                int row = this.model.getRowCount() + 1;
                this.model.setRowCount(row);
                this.model.setValueAt(rs.getString("id"), row - 1, 0);
                this.model.setValueAt(rs.getString("name"), row - 1, 1);
                this.model.setValueAt(rs.getString("email"), row - 1, 2);
                this.model.setValueAt(rs.getString("date_created"), row - 1, 3);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e);
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
        }
        Utils.close(rs);
        Utils.close(st);
    }
}

