/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui.action;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.music.playlist.PlaylistFile;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ImportPlaylist
implements ActionListener {
    private static final Logger log = Logger.getLogger(ImportPlaylist.class);
    private final JFrame parent;
    private final Database db;
    private final CollectionManager cm;
    private final Resources r;

    public ImportPlaylist(JFrame parent, Database db, CollectionManager cm, Resources r) {
        this.parent = parent;
        this.db = db;
        this.cm = cm;
        this.r = r;
    }

    public void actionPerformed(ActionEvent evt) {
        String error = "";
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new PlaylistFileFilter(this.r.getCurrentLocale()));
        if (fc.showOpenDialog(this.parent) == 0) {
            try {
                File file = fc.getSelectedFile();
                String playlistName = this.getPlaylistName(file);
                PlaylistFile playlistFile = PlaylistFile.getPlaylistFile(file.getAbsoluteFile());
                if (playlistFile == null) {
                    throw new Exception("Unsupported playlist type");
                }
                Track[] tracks = this.getTracksFromPlaylist(playlistFile);
                Locale locale = this.r.getCurrentLocale();
                int playlistId = this.cm.savePlaylist(playlistName, tracks);
                if (playlistId != -1) {
                    JOptionPane.showMessageDialog(this.parent, locale.getString("gui.message.playlistImported"), "Sockso", 1);
                    return;
                }
                error = locale.getString("gui.message.playlistImportFailed");
            }
            catch (Exception e) {
                log.error((Object)e);
                error = e.getMessage();
            }
            JOptionPane.showMessageDialog(this.parent, error, "Sockso", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Track[] getTracksFromPlaylist(PlaylistFile playlistFile) throws SQLException {
        ArrayList<Track> tracks = new ArrayList<Track>();
        ResultSet rs = null;
        Statement st = null;
        try {
            for (String path : playlistFile.getPaths()) {
                String sql = Track.getSelectFromSql() + " where t.path = ? ";
                st = this.db.prepare(sql);
                st.setString(1, path);
                rs = st.executeQuery();
                if (!rs.next()) continue;
                tracks.add(Track.createFromResultSet(rs));
            }
        }
        finally {
            rs.close();
            st.close();
        }
        return tracks.toArray(new Track[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPlaylistName(File file) throws SQLException {
        String string;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            String newName = file.getName();
            newName = newName.substring(0, newName.indexOf("."));
            String sql = " select p.name  from playlists p ";
            st = this.db.prepare(" select p.name  from playlists p ");
            rs = st.executeQuery();
            int clashes = 0;
            while (rs.next()) {
                String name = rs.getString("name");
                if (!name.equals(newName) && !name.matches("^" + newName + " \\(\\d+\\)")) continue;
                ++clashes;
            }
            if (clashes > 0) {
                newName = newName + " (" + clashes + ")";
            }
            string = newName;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return string;
    }

    class PlaylistFileFilter
    extends FileFilter {
        private final Locale locale;

        public PlaylistFileFilter(Locale locale) {
            this.locale = locale;
        }

        public String getDescription() {
            return this.locale.getString("gui.label.playlists");
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String[] validExtensions = new String[]{"m3u"};
            String extension = Utils.getExt(file);
            for (String validExtension : validExtensions) {
                if (!extension.equals(validExtension)) continue;
                return true;
            }
            return false;
        }
    }
}

