/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag.aac;

import com.pugh.sockso.music.tag.aac.AtomHeader;
import com.pugh.sockso.music.tag.aac.AtomType;
import com.pugh.sockso.music.tag.aac.FileUtil;

public class Atom {
    private AtomHeader header;
    private String data;

    public Atom(AtomHeader header, byte[] data) {
        this.header = header;
        if (header.getType() == AtomType.TRACK || header.getType() == AtomType.DISC) {
            long index = FileUtil.readLong(data, 10, 2);
            long total = FileUtil.readLong(data, 12, 2);
            this.data = index + ":" + total;
        } else {
            this.data = new String(data, 8, data.length - 8);
        }
    }

    public Atom(AtomHeader header, String data) {
        this.header = header;
        this.data = data;
    }

    public AtomHeader getHeader() {
        return this.header;
    }

    public String getData() {
        return this.data;
    }

    public String toString() {
        return "Atom: header[" + this.header + "] data[" + this.data + "]";
    }
}

