/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.web.HttpResponseCookie;
import com.pugh.sockso.web.PageTemplate;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.User;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.jamon.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse
implements Response {
    private static final Logger log = Logger.getLogger(HttpResponse.class);
    protected static final String HTTP_EOL = "\r\n";
    private final Properties p;
    private final Locale locale;
    private final boolean canGzip;
    private final Hashtable<String, String> headers;
    protected final Vector<HttpResponseCookie> cookies;
    private Database db;
    private User user;
    private OutputStream stream;
    private boolean responseSent;
    private boolean useGzip;
    private boolean cookiesEnabled;
    protected int status;

    public HttpResponse(OutputStream stream, Database db, Properties p, Locale locale, User user, boolean canGzip) {
        this.stream = stream;
        this.db = db;
        this.p = p;
        this.user = user;
        this.locale = locale;
        this.canGzip = canGzip;
        this.useGzip = false;
        this.cookiesEnabled = true;
        this.status = 200;
        this.headers = new Hashtable(10);
        this.cookies = new Vector();
        this.responseSent = false;
        this.addHeader("Server", "Sockso");
        this.addHeader("Connection", "close");
        this.addHeader("Accept-Ranges", "none");
    }

    @Override
    public void setCookiesEnabled(boolean cookiesEnabled) {
        this.cookiesEnabled = cookiesEnabled;
    }

    @Override
    public void enableGzip() {
        this.useGzip = true;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void addCookie(HttpResponseCookie cookie) {
        this.cookies.remove(cookie);
        this.cookies.addElement(cookie);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void sendHeaders() {
        PrintWriter out = new PrintWriter(this.stream, true);
        out.print("HTTP/1.0 " + this.status + " " + this.getStatusText(this.status) + HTTP_EOL);
        if (this.canGzip && this.useGzip) {
            this.addHeader("Content-Encoding", "gzip");
        }
        for (String name : this.headers.keySet()) {
            this.writeHeader(out, name, this.headers.get(name));
        }
        if (this.cookiesEnabled) {
            for (HttpResponseCookie cookie : this.cookies) {
                this.writeHeader(out, "Set-Cookie", cookie.toString());
            }
        }
        out.print(HTTP_EOL);
        out.flush();
    }

    private void writeHeader(PrintWriter out, String name, String value) {
        out.print(name + ": " + value + HTTP_EOL);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public void showHtml(Renderer renderer) throws IOException {
        this.showTemplate(renderer, "text/html; charset=\"UTF-8\"");
    }

    @Override
    public void showHtml(PageTemplate tpl) throws IOException, SQLException {
        tpl.setRecentUsers(this.getRecentUsers());
        tpl.setProperties(this.p);
        tpl.setLocale(this.locale);
        tpl.setUser(this.user);
        this.showHtml(tpl.makeRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<User> getRecentUsers() throws SQLException {
        Vector<User> vector;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            Vector<User> users = new Vector<User>();
            String sql = " select distinct u.id, u.name  from play_log l  inner join users u  on u.id = l.user_id  where date_played > ? ";
            long fiveMinutesInMilliseconds = 300000L;
            Timestamp fiveMinutesAgo = new Timestamp(new Date().getTime() - 300000L);
            st = this.db.prepare(" select distinct u.id, u.name  from play_log l  inner join users u  on u.id = l.user_id  where date_played > ? ");
            st.setTimestamp(1, fiveMinutesAgo);
            rs = st.executeQuery();
            while (rs.next()) {
                users.add(new User(rs.getInt("id"), rs.getString("name")));
            }
            vector = users;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    protected void setDatabase(Database db) {
        this.db = db;
    }

    @Override
    public void showRss(Renderer renderer) throws IOException {
        this.showTemplate(renderer, "text/xml; charset=\"UTF-8\"");
    }

    @Override
    public void showJson(Renderer renderer) throws IOException {
        this.showTemplate(renderer, "application/json; charset=\"UTF-8\"");
    }

    @Override
    public void showText(Renderer renderer) throws IOException {
        this.showTemplate(renderer, "text/plain");
    }

    @Override
    public void showTemplate(Renderer renderer, String contentType) throws IOException {
        this.addHeader("Content-type", contentType);
        this.showTemplate(renderer);
    }

    @Override
    public void showTemplate(Renderer renderer) throws IOException {
        this.addHeader("Cache-Control", "private");
        this.enableGzip();
        this.sendHeaders();
        boolean doGzip = this.canGzip && this.useGzip;
        OutputStream out = doGzip ? new GZIPOutputStream(this.stream) : this.stream;
        renderer.renderTo((Writer)new OutputStreamWriter(out));
        if (doGzip) {
            ((GZIPOutputStream)out).finish();
        }
        this.stream.flush();
        this.responseSent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData(DataInputStream in) throws IOException {
        DataOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(this.canGzip && this.useGzip ? new GZIPOutputStream(this.stream) : this.stream);
                while (true) {
                    out.writeByte(in.readByte());
                }
            }
            catch (EOFException eOFException) {
                Utils.close(out);
            }
        }
        catch (Throwable throwable) {
            Utils.close(out);
            throw throwable;
        }
    }

    @Override
    public void redirect(String path) throws IOException {
        this.setStatus(302);
        this.addHeader("Location", path);
        this.sendHeaders();
        this.stream.flush();
        this.responseSent = true;
    }

    @Override
    public boolean responseSent() {
        return this.responseSent;
    }

    protected String getStatusText(int code) {
        String sCode = "" + code;
        String[] texts = new String[]{"200", "Ok", "201", "Created", "202", "Accepted", "203", "Non-Authoritative Information", "204", "No Content", "205", "Reset Content", "206", "Partial Content", "300", "Multiple Choices", "301", "Moved Permanently", "302", "Not Found", "303", "See Other", "304", "Not Modified", "305", "Use Proxy", "307", "Temporary Redirect", "400", "Bad Request", "401", "Unauthorised", "402", "Payment Required", "403", "Forbidden", "404", "Not Found", "405", "Method Not Found", "406", "Not Acceptable", "407", "Proxy Authentication Required", "408", "Request Timeout", "409", "Conflict", "410", "Gone", "411", "Length Required", "412", "Precondition Failed", "413", "Request Entity Too Large", "414", "Request URI Too Long", "415", "Unsupported Media Type", "416", "Requested Range Not Satisfiable", "417", "Expectation Failed", "500", "Internal Server Error", "501", "Not Implemented", "502", "Bad Gateway", "503", "Service Unavailable", "504", "Gateway Timeout", "505", "HTTP Version Not Supported"};
        for (int i = 0; i < texts.length; i += 2) {
            if (!sCode.equals(texts[i])) continue;
            return texts[i + 1];
        }
        return "";
    }
}

