/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.web.InputBuffer;
import com.pugh.sockso.web.StringOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MultipartSection {
    private static final Logger log = Logger.getLogger(MultipartSection.class);
    private String name = "";
    private String filename = "";
    private String contentType = "text/plain";
    private String data;
    private File temporaryFile = File.createTempFile("sockso-upload-" + Math.random(), "dat");

    public void process(InputBuffer buffer, String boundary) throws IOException {
        this.parseHeaders(buffer);
        boolean writeToFile = !this.filename.equals("");
        DataOutput out = writeToFile ? new DataOutputStream(new FileOutputStream(this.temporaryFile)) : new StringOutputStream();
        this.parseData(buffer, boundary, out);
        if (!writeToFile) {
            this.data = ((StringOutputStream)out).toString();
        }
    }

    protected void parseData(InputBuffer buffer, String boundary, DataOutput out) throws IOException {
        int c;
        String terminator = "\r\n--" + boundary;
        int length = terminator.length();
        char firstChar = terminator.charAt(0);
        int[] term = new int[length];
        for (int i = 0; i < length; ++i) {
            term[i] = terminator.charAt(i);
        }
        block1: while ((c = buffer.read()) != -1) {
            if (c == firstChar) {
                for (int i = 1; i < length; ++i) {
                    int d = buffer.readDirectly();
                    buffer.putBack(d);
                    if ((char)d != term[i]) break;
                    if (i == length - 1) break block1;
                }
            }
            out.writeByte(c);
        }
        buffer.skip(1);
    }

    protected void parseHeaders(InputBuffer buffer) throws IOException {
        String header;
        while ((header = buffer.readLine()) != null && !header.equals("")) {
            Pattern p = Pattern.compile("(.*?): (.*)");
            Matcher m = p.matcher(header);
            if (!m.matches()) continue;
            String headerName = m.group(1).toLowerCase();
            String headerData = m.group(2);
            if (headerName.equals("content-type")) {
                this.contentType = headerData;
                continue;
            }
            if (!headerName.equals("content-disposition")) continue;
            this.processContentDisposition(headerData);
        }
    }

    protected void processContentDisposition(String headerData) {
        for (String pairData : headerData.split(";")) {
            String[] parts = pairData.split("=");
            if (parts.length != 2) continue;
            String pairName = parts[0].trim();
            String pairValue = parts[1].substring(1, parts[1].length() - 1);
            if (pairName.equals("name")) {
                this.name = pairValue;
                continue;
            }
            if (!pairName.equals("filename")) continue;
            this.filename = pairValue;
        }
    }

    public String getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public File getTemporaryFile() {
        return this.temporaryFile;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return "(MultipartSection) Name: '" + this.name + "'; " + "Filename: '" + this.filename + "'; " + "content-type: '" + this.contentType + "';";
    }
}

