/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.User;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebAction {
    private Request req;
    private Response res;
    private User user;
    private Locale locale;
    private Database db;
    private Properties p;

    public void init(Request req, Response res, User user, Locale locale) {
        this.req = req;
        this.res = res;
        this.user = user;
        this.locale = locale;
    }

    public abstract void handleRequest() throws Exception;

    public boolean requiresLogin() {
        return true;
    }

    protected Request getRequest() {
        return this.req;
    }

    protected Response getResponse() {
        return this.res;
    }

    protected User getUser() {
        return this.user;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    protected Database getDatabase() {
        return this.db;
    }

    protected Properties getProperties() {
        return this.p;
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setResponse(Response res) {
        this.res = res;
    }

    public void setRequest(Request req) {
        this.req = req;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setProperties(Properties p) {
        this.p = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Track> getLatestTracks(int limit) throws SQLException {
        Vector<Track> vector;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            String sql = Track.getSelectFromSql() + " order by t.date_added desc " + " limit ? ";
            st = this.db.prepare(sql);
            st.setInt(1, limit);
            rs = st.executeQuery();
            vector = Track.createVectorFromResultSet(rs);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    protected String getTrackTypeSqlFilter() {
        StringBuffer filterBuffer = new StringBuffer("");
        String trackTypes = this.req.getArgument("trackType");
        for (String type : trackTypes.split(",")) {
            if (type.equals("")) continue;
            int length = type.length();
            filterBuffer.append(" and lower(substr(t.path,length(t.path)-" + (length - 1) + "," + length + ")) = '" + type + "' ");
        }
        String filter = filterBuffer.toString();
        return filter.equals("") ? "" : " where " + filter.substring(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Track> getRandomTracks() throws SQLException {
        Vector<Track> vector;
        String limit = this.p.get("playlists.random.trackLimit", "100");
        String sql = Track.getSelectFromSql() + this.getTrackTypeSqlFilter() + " order by " + this.db.getRandomFunction() + "() " + " limit ? ";
        PreparedStatement st = null;
        try {
            st = this.db.prepare(sql);
            st.setInt(1, Integer.parseInt(limit));
            vector = Track.createVectorFromResultSet(st.executeQuery());
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
        return vector;
    }
}

