/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.browse;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.web.browse.TPopular;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Popularer
extends WebAction {
    private static final Logger log = Logger.getLogger(Popularer.class);

    @Override
    public void handleRequest() throws IOException, SQLException {
        this.showPopularTracks(this.getPopularTracks());
    }

    protected void showPopularTracks(Vector<Track> tracks) throws IOException, SQLException {
        TPopular tpl = new TPopular();
        tpl.setTracks(tracks);
        this.getResponse().showHtml(tpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Track> getPopularTracks() throws SQLException {
        Vector<Track> vector;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Properties p = this.getProperties();
            Database db = this.getDatabase();
            String sql = Track.getSelectSql() + " , count(l.id) as playCount " + " from tracks t " + " inner join artists ar " + " on ar.id = t.artist_id " + " inner join albums al " + " on al.id = t.album_id " + " left outer join play_log l " + " on l.track_id = t.id " + " group by artistId, artistName, albumId, albumName, trackId, " + " trackName, trackPath, trackNo, dateAdded " + " having count(l.id) > 0 " + " order by count(l.id) desc " + " limit ? ";
            st = db.prepare(sql);
            st.setInt(1, (int)p.get("browse.popularTracks.count", 20L));
            rs = st.executeQuery();
            Vector<Track> tracks = new Vector<Track>();
            while (rs.next()) {
                Track track = Track.createFromResultSet(rs);
                track.setPlayCount(rs.getInt("playCount"));
                tracks.addElement(track);
            }
            vector = tracks;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }
}

