#!/bin/sh
startdir=$1

if [ $(echo $1|wc -w) -eq 0 ];then
	echo "Usage: install.sh /path/to"
	echo "For ex. install.sh /usr/ will install into /usr/"
	echo "        install.sh /usr/local/ will install into /usr/local/" 
	exit 1
fi

echo "Installing in to $startdir..."


mkdir -p $startdir/bin/ || return 1
install -m0755 wbarconf $startdir/bin/ || return 1

mkdir -p $startdir/share/wbarconf/
install -m0644 README $startdir/share/wbarconf/ || return 1
install -m0644 COPYING $startdir/share/wbarconf/ || return 1

mkdir -p $startdir/share/locale/ || return 1
cp -av locale/* $startdir/share/locale/ || return 1
chmod 0755 -R  $startdir/share/ || return 1
find $startdir/share/locale/ -name wbarconf.po -print | xargs rm -f
install -m0644 messages.pot $startdir/share/wbarconf/ || return 1

cp -av wbarbacks $startdir/share/wbarconf/ || return 1
chmod 0655 -R  $startdir/share/wbarconf/ || return 1

mkdir -p $startdir/share/pixmaps/
install -m0644 wbarconf.png $startdir/share/pixmaps/ || return 1

mkdir -p $startdir/share/applications/
install -m0644 wbarconf.desktop $startdir/share/applications/ || return 1

echo "Installation complete."
