/*
 *      EasyPMP common header.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
 * http://www.gnu.org/copyleft/gpl.html .
 *
 */

/* $Id: easypmp.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__EASYPMP_H__
#define	__EASYPMP_H__


#ifdef	__cplusplus
extern "C" {
#endif/*__cplusplus*/

/**
 * \addtogroup common
 * @{
 */

enum {
	EASYPMPP_START				= 0x00010000,
	EASYPMPP_OPEN				= 0x00020000,
	EASYPMPP_MUSIC_GMI			= 0x00030000,
	EASYPMPP_MUSIC_UPDATE		= 0x00040000,
	EASYPMPP_PLAYLIST_CONVERT	= 0x02050000,
	EASYPMPP_CLOSE				= 0x00060000,
	EASYPMPP_END				= 0x00070000,

	EASYPMPSP_START				= 0x00000001,
	EASYPMPSP_PROGRESS			= 0x00000002,
	EASYPMPSP_SKIPPED			= 0x00000003,
	EASYPMPSP_WARN_FAILURE		= 0x00000004,
	EASYPMPSP_WARN_EMPTY		= 0x00000005,
	EASYPMPSP_WARN_PLAYLIST		= 0x00000006,
	EASYPMPSP_SKIP_PLAYLIST		= 0x00000007,
	EASYPMPSP_MISSING_MEDIA		= 0x00000008,
	EASYPMPSP_JSPL_ERROR		= 0x00000009,
	EASYPMPSP_JSPL_ERROR_POS	= 0x0000000A,
	EASYPMPSP_JSPL_ERROR_LINE	= 0x0000000B,
	EASYPMPSP_JSPL_OUTPUT		= 0x0000000C,
	EASYPMPSP_END				= 0x0000000D,
};

enum {
	EASYPMPE_SUCCESS = 0,
	EASYPMPE_PMPERROR,
	EASYPMPE_CANCEL,
	EASYPMPE_INSUFFICIENT_MEMORY,
	EASYPMPE_PLAYLIST_READ,
};

#define	MAKE_PMP_ERROR(code)	(((code) << 16) | EASYPMPE_PMPERROR)

enum {
	MODE_NONE =			0,
	MODE_DATABASE =			0x00000001,
	MODE_DATABASE_UPDATE =		0x00000002,
	MODE_DATABASE_REPR =		0x00000004,
	MODE_PLAYLIST =			0x00000010,
	MODE_PLAYLIST_RECONVERT =	0x00000100,
	MODE_PLAYLIST_FIND =	0x00000200,
	MODE_PLAYLIST_SKIP =	0x00000400,
	MODE_PLAYLIST_JSPL =	0x00000800,
	MODE_LIST_DEVICES =		0x00001000,
	MODE_HELP =			0x00010000,
	MODE_HELP_VARIABLE =		0x00020000,
	MODE_VERSION =			0x00040000,
};

typedef struct {
	uint32_t verb;
	uint32_t media_info_source;
	int repr_level;
	ucs2char_t path_to_root[MAX_PATH];
	ucs2char_t path_to_include[MAX_PATH];
	char model[128];
	char *system_encoding;
	char *music_encoding;
	char *mbs_strip_words;
	ucs2char_t** strip_words;
	int num_strip_words;

	ucs2char_t* path_to_pmp_music;
	ucs2char_t* path_to_pmp_playlist;
	ucs2char_t* path_to_playlist_source;
	int subdir_playlist_source;
} option_t;

typedef struct {
	ucs2char_t pathname[MAX_PATH];
	ucs2char_t filename[MAX_PATH];
} easypmp_filename_t;

typedef struct {
	uint32_t num_elements;
	easypmp_filename_t* elements;
} easypmp_filelist_t;

typedef int (*easypmp_enumerate_progress_t)(void *instance, const ucs2char_t* path, const ucs2char_t* file, size_t n);

typedef int (*easypmp_progress_t)(
	void *instance,
	int phase,
	int param_int,
	double param_float,
	ucs2char_t* param_str
	);

int
easypmp_enumerate_music(
	easypmp_filelist_t* fl,
	pmp_t* pmp,
	const option_t* opt,
	easypmp_enumerate_progress_t proc,
	void *instance
	);

int
easypmp_enumerate_playlist(
	easypmp_filelist_t* fl,
	pmp_t* pmp,
	const option_t* opt,
	easypmp_enumerate_progress_t proc,
	void *instance
	);

int
easypmp_database(
	pmp_t* pmp,
	const easypmp_filelist_t* fl,
	const option_t* opt,
	pmp_music_record_t** ptr_records,
	uint32_t* ptr_num_records,
	easypmp_progress_t progress,
	void *instance
	);

int
easypmp_set_strip_words(
	option_t* opt,
	const ucs2char_t* str
	);

int
easypmp_playlist(
	pmp_t* pmp,
	const easypmp_filelist_t* playlists,
	const easypmp_filelist_t* musics,
	const option_t* opt,
	pmp_music_record_t* records,
	uint32_t num_records,
	easypmp_progress_t progress,
	void *instance
	);

void
easypmp_free_filelist(
	easypmp_filelist_t* fl
	);

/** @} */

#ifdef	__cplusplus
}
#endif/*__cplusplus*/


#endif/*__EASYPMP_H__*/
